package java.io;

import ej.annotation.Nullable;

/**
 * An InputStreamReader is a bridge from byte streams to character streams: It reads bytes and
 * decodes them into characters using a specified <code>charset</code>. The charset that it uses may
 * be specified by name or may be given explicitly, or the platform's default charset may be
 * accepted.
 *
 * <p>
 * Each invocation of one of an InputStreamReader's read() methods may cause one or more bytes to be
 * read from the underlying byte-input stream. To enable the efficient conversion of bytes to
 * characters, more bytes may be read ahead from the underlying stream than are necessary to satisfy
 * the current read operation.
 *
 * <p>
 * For top efficiency, consider wrapping an InputStreamReader within a BufferedReader. For example:
 *
 * <pre>
 * BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
 * </pre>
 *
 * @see InputStream
 */
public class InputStreamReader extends Reader {

	/**
	 * Creates an InputStreamReader that uses the default charset.
	 *
	 * @param in
	 *        An InputStream
	 */
	public InputStreamReader(InputStream in) {
		throw new RuntimeException();
	}

	/**
	 * Creates an InputStreamReader that uses the named charset.
	 *
	 * @param in
	 *        An InputStream
	 *
	 * @param charsetName
	 *        The name of a supported <code>charset</code>
	 *
	 * @exception UnsupportedEncodingException
	 *            If the named charset is not supported
	 */
	public InputStreamReader(InputStream in, String charsetName) throws UnsupportedEncodingException {
		throw new RuntimeException();
	}

	/**
	 * Close the stream. Closing a previously closed stream has no effect.
	 */
	@Override
	public void close() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Returns the name of the character encoding being used by this stream.
	 *
	 * <p>
	 * If the encoding has an historical name then that name is returned; otherwise the encoding's
	 * canonical name is returned.
	 *
	 * <p>
	 * If this instance was created with the {@link #InputStreamReader(InputStream, String)} constructor
	 * then the returned name, being unique for the encoding, may differ from the name passed to the
	 * constructor. This method will return <code>null</code> if the stream has been closed.
	 * </p>
	 *
	 * @return The historical name of this encoding, or <code>null</code> if the stream has been closed
	 *
	 */
	@Nullable
	public String getEncoding() {
		throw new RuntimeException();
	}

	/**
	 * Reads a single character.
	 *
	 * @return The character read, or -1 if the end of the stream has been reached
	 *
	 * @exception IOException
	 *            If an I/O error occurs
	 */
	@Override
	public int read() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads characters into a portion of an array.
	 *
	 * @param cbuf
	 *        Destination buffer
	 * @param offset
	 *        Offset at which to start storing characters
	 * @param length
	 *        Maximum number of characters to read
	 *
	 * @return The number of characters read, or -1 if the end of the stream has been reached
	 *
	 * @exception IOException
	 *            If an I/O error occurs
	 */
	@Override
	public int read(char[] cbuf, int offset, int length) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Tells whether this stream is ready to be read. An InputStreamReader is ready if its input buffer
	 * is not empty, or if bytes are available to be read from the underlying byte stream.
	 *
	 * @exception IOException
	 *            If an I/O error occurs
	 */
	@Override
	public boolean ready() throws IOException {
		throw new RuntimeException();
	}

}