/*
 * Java
 *
 * Copyright 2016-2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.ecom.wifi;

/**
 * Wireless Access Point (WAP, often shorten as AP).
 */
public class AccessPoint {

	/**
	 * Constructs a Wi-Fi Access Point instance.
	 *
	 * @param ssid
	 *            the access point SSID or <code>null</code>.
	 * @param bssid
	 *            the access point BSSID or <code>null</code>.
	 * @param rssi
	 *            the access point RSSI.
	 * @param channel
	 *            the access point channel.
	 * @param securityMode
	 *            the access point security mode or <code>null</code>.
	 * @param wpsModes
	 *            the access point WPS modes or <code>null</code>.
	 */
	public AccessPoint(String ssid, byte[] bssid, float rssi, int channel, SecurityMode securityMode,
			WPSMode[] wpsModes) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a Wi-Fi access point instance.
	 *
	 * @param ssid
	 *            the access point SSID.
	 * @param securityMode
	 *            the access point security mode.
	 */
	public AccessPoint(String ssid, SecurityMode securityMode) {
		throw new RuntimeException();
	}

	/**
	 * Gets the Basic Service Set IDentification (BSSID). This is a MAC address of
	 * the access point in infrastructure mode.
	 *
	 * @return the access point BSSID (consists of 6 bytes).
	 */
	public byte[] getBSSID() {
		throw new RuntimeException();
	}

	/**
	 * Gets the channel of this access point.
	 *
	 * @return the access point channel.
	 */
	public int getChannel() {
		throw new RuntimeException();
	}

	/**
	 * Gets the Received Signal Strength Identification (RSSI) of this access point.
	 *
	 * This is a negative value expressed in dBm.
	 *
	 * @return the access point RSSI.
	 */
	public float getRSSI() {
		throw new RuntimeException();
	}

	/**
	 * Gets the security mode ({@link SecurityMode}).
	 *
	 * @return the access point security mode or <code>null</code> if not set.
	 */
	public SecurityMode getSecurityMode() {
		throw new RuntimeException();
	}

	/**
	 * Gets the Service Set IDentification (SSID) of the network.
	 *
	 * @return the access point SSID or <code>null</code> if not set.
	 */
	public String getSSID() {
		throw new RuntimeException();
	}

	/**
	 * Gets the Wi-Fi Protected Setup (WPS) modes supported by this access point.
	 *
	 * @return the supported WPS modes or an empty array if this access point
	 *         doesn't support WPS
	 */
	public WPSMode[] getWPSCapabilities() {
		throw new RuntimeException();
	}

	/**
	 * Sets the security mode ({@link SecurityMode}).
	 *
	 * @param securityMode
	 *            the access point security mode or <code>null</code>.
	 */
	public void setSecurityMode(SecurityMode securityMode) {
		throw new RuntimeException();
	}

	/**
	 * Sets the Service Set IDentification (SSID) of the network.
	 *
	 * @param ssid
	 *            the SSID or <code>null</code>.
	 */
	public void setSSID(String ssid) {
		throw new RuntimeException();
	}

}
