package java.lang;

import java.io.Serializable;

import ej.annotation.Nullable;

/**
 * A thread-safe, mutable sequence of characters. A string buffer is like a {@link String}, but can
 * be modified. At any point in time it contains some particular sequence of characters, but the
 * length and content of the sequence can be changed through certain method calls.
 * <p>
 * String buffers are safe for use by multiple threads. The methods are synchronized where necessary
 * so that all the operations on any particular instance behave as if they occur in some serial
 * order that is consistent with the order of the method calls made by each of the individual
 * threads involved.
 * <p>
 * The principal operations on a <code>StringBuffer</code> are the <code>append</code> and
 * <code>insert</code> methods, which are overloaded so as to accept data of any type. Each
 * effectively converts a given datum to a string and then appends or inserts the characters of that
 * string to the string buffer. The <code>append</code> method always adds these characters at the
 * end of the buffer; the <code>insert</code> method adds the characters at a specified point.
 * <p>
 * For example, if <code>z</code> refers to a string buffer object whose current contents are "
 * <code>start</code>", then the method call <code>z.append("le")</code> would cause the string
 * buffer to contain " <code>startle</code>", whereas <code>z.insert(4, "le")</code> would alter the
 * string buffer to contain "<code>starlet</code>".
 * <p>
 * In general, if sb refers to an instance of a <code>StringBuffer</code>, then
 * <code>sb.append(x)</code> has the same effect as <code>sb.insert(sb.length(),&nbsp;x)</code>.
 * <p>
 * Whenever an operation occurs involving a source sequence (such as appending or inserting from a
 * source sequence) this class synchronizes only on the string buffer performing the operation, not
 * on the source.
 * <p>
 * Every string buffer has a capacity. As long as the length of the character sequence contained in
 * the string buffer does not exceed the capacity, it is not necessary to allocate a new internal
 * buffer array. If the internal buffer overflows, it is automatically made larger.
 *
 */
public final class StringBuffer implements Appendable, CharSequence, Serializable {

	/**
	 * Constructs a string buffer with no characters in it and an initial capacity of 16 characters.
	 */
	public StringBuffer() {
		throw new RuntimeException();
	}

	/**
	 * Constructs a string buffer that contains the same characters as the specified
	 * <code>CharSequence</code>. The initial capacity of the string buffer is <code>16</code> plus the
	 * length of the <code>CharSequence</code> argument.
	 * <p>
	 * If the length of the specified <code>CharSequence</code> is less than or equal to zero, then an
	 * empty buffer of capacity <code>16</code> is returned.
	 *
	 * @param seq
	 *        the sequence to copy.
	 * @exception NullPointerException
	 *            if <code>seq</code> is <code>null</code>
	 */
	public StringBuffer(CharSequence seq) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a string buffer with no characters in it and the specified initial capacity.
	 *
	 * @param capacity
	 *        the initial capacity.
	 * @exception NegativeArraySizeException
	 *            if the <code>capacity</code> argument is less than <code>0</code>.
	 */
	public StringBuffer(int capacity) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a string buffer initialized to the contents of the specified string. The initial
	 * capacity of the string buffer is <code>16</code> plus the length of the string argument.
	 *
	 * @param str
	 *        the initial contents of the buffer.
	 * @exception NullPointerException
	 *            if <code>str</code> is <code>null</code>
	 */
	public StringBuffer(String str) {
		throw new RuntimeException();
	}

	/**
	 * Appends the string representation of the boolean argument to the sequence.
	 * <p>
	 * The overall effect is exactly as if the argument were converted to a string
	 * by the method String.valueOf(boolean), and the characters of that string were
	 * then appended to this character sequence.
	 *
	 * @param b
	 *            a {@code boolean}.
	 * @return a reference to this object.
	 */
	public synchronized StringBuffer append(boolean b) {
		throw new RuntimeException();
	}

	@Override
	public synchronized StringBuffer append(char c) {
		throw new RuntimeException();
	}

	/**
	 * Appends the string representation of the char array argument to this
	 * sequence.
	 * <p>
	 * The characters of the array argument are appended, in order, to the contents
	 * of this sequence. The length of this sequence increases by the length of the
	 * argument.
	 * <p>
	 * The overall effect is exactly as if the argument were converted to a string
	 * by the method String.valueOf(char[]), and the characters of that string were
	 * then appended to this character sequence.
	 *
	 * @param str
	 *            the characters to be appended.
	 * @return a reference to this object.
	 */
	public synchronized StringBuffer append(char[] str) {
		throw new RuntimeException();
	}

	/**
	 * Appends the string representation of a subarray of the {@code char} array argument to this
	 * sequence.
	 * <p>
	 * Characters of the {@code char} array {@code str}, starting at index {@code offset}, are appended,
	 * in order, to the contents of this sequence. The length of this sequence increases by the value of
	 * {@code len}.
	 * <p>
	 * The overall effect is exactly as if the arguments were converted to a string by the method
	 * {@link String#valueOf(char[],int,int)}, and the characters of that string were then
	 * {@link #append(String) appended} to this character sequence.
	 *
	 * @param str
	 *        the characters to be appended.
	 * @param offset
	 *        the index of the first {@code char} to append.
	 * @param len
	 *        the number of {@code char}s to append.
	 * @return a reference to this object.
	 * @throws IndexOutOfBoundsException
	 *         if {@code offset < 0} or {@code len < 0} or {@code offset+len > str.length}
	 */
	public synchronized StringBuffer append(char[] str, int offset, int len) {
		throw new RuntimeException();
	}

	/**
	 * Appends the specified <code>CharSequence</code> to this sequence.
	 * <p>
	 * The characters of the <code>CharSequence</code> argument are appended, in order, increasing the
	 * length of this sequence by the length of the argument.
	 *
	 * <p>
	 * The result of this method is exactly the same as if it were an invocation of this.append(s, 0,
	 * s.length());
	 *
	 * <p>
	 * This method synchronizes on this (the destination) object but does not synchronize on the source
	 * (<code>s</code>).
	 *
	 * <p>
	 * If <code>s</code> is <code>null</code>, then the four characters <code>"null"</code> are
	 * appended.
	 *
	 * @param s
	 *        the <code>CharSequence</code> to append.
	 * @return a reference to this object.
	 */
	@Override
	public synchronized StringBuffer append(@Nullable CharSequence s) {
		throw new RuntimeException();
	}

	/**
	 * Appends a subsequence of the specified {@code CharSequence} to this sequence.
	 * <p>
	 * Characters of the argument {@code s}, starting at index {@code start}, are appended, in order, to
	 * the contents of this sequence up to the (exclusive) index {@code end}. The length of this
	 * sequence is increased by the value of {@code end - start}.
	 * <p>
	 * Let <i>n</i> be the length of this character sequence just prior to execution of the
	 * {@code append} method. Then the character at index <i>k</i> in this character sequence becomes
	 * equal to the character at index <i>k</i> in this sequence, if <i>k</i> is less than <i>n</i>;
	 * otherwise, it is equal to the character at index <i>k+start-n</i> in the argument {@code s}.
	 * <p>
	 * If {@code s} is {@code null}, then this method appends characters as if the s parameter was a
	 * sequence containing the four characters {@code "null"}.
	 *
	 * @param s
	 *        the sequence to append.
	 * @param start
	 *        the starting index of the subsequence to be appended.
	 * @param end
	 *        the end index of the subsequence to be appended.
	 * @return a reference to this object.
	 * @throws IndexOutOfBoundsException
	 *         if {@code start} is negative, or {@code start} is greater than {@code end} or {@code end}
	 *         is greater than {@code s.length()}
	 */
	@Override
	public synchronized StringBuffer append(@Nullable CharSequence s, int start, int end) {
		throw new RuntimeException();
	}

	/**
	 * Appends the string representation of the double argument to this sequence.
	 * <p>
	 * The overall effect is exactly as if the argument were converted to a string
	 * by the method String.valueOf(double), and the characters of that string were
	 * then appended to this character sequence.
	 *
	 * @param d
	 *            a {@code double}.
	 * @return a reference to this object.
	 */
	public synchronized StringBuffer append(double d) {
		throw new RuntimeException();
	}

	/**
	 * Appends the string representation of the float argument to this sequence.
	 * <p>
	 * The overall effect is exactly as if the argument were converted to a string
	 * by the method String.valueOf(float), and the characters of that string were
	 * then appended to this character sequence.
	 *
	 * @param f
	 *            a {@code float}.
	 * @return a reference to this object.
	 */
	public synchronized StringBuffer append(float f) {
		throw new RuntimeException();
	}

	/**
	 * Appends the string representation of the int argument to this sequence.
	 * <p>
	 * The overall effect is exactly as if the argument were converted to a string
	 * by the method String.valueOf(int), and the characters of that string were
	 * then appended to this character sequence.
	 *
	 * @param i
	 *            an {@code int}.
	 * @return a reference to this object.
	 */
	public synchronized StringBuffer append(int i) {
		throw new RuntimeException();
	}

	/**
	 * Appends the string representation of the long argument to this sequence.
	 * <p>
	 * The overall effect is exactly as if the argument were converted to a string
	 * by the method String.valueOf(long), and the characters of that string were
	 * then appended to this character sequence.
	 *
	 * @param lng
	 *            a {@code long}.
	 * @return a reference to this object.
	 */
	public synchronized StringBuffer append(long lng) {
		throw new RuntimeException();
	}

	/**
	 * Appends the string representation of the Object argument.
	 * <p>
	 * The overall effect is exactly as if the argument were converted to a string
	 * by the method String.valueOf(Object), and the characters of that string were
	 * then appended to this character sequence.
	 *
	 * @param obj
	 *            an {@code Object}.
	 * @return a reference to this object.
	 */
	public synchronized StringBuffer append(@Nullable Object obj) {
		throw new RuntimeException();
	}

	/**
	 * Appends the specified string to this character sequence.
	 * <p>
	 * The characters of the String argument are appended, in order, increasing the
	 * length of this sequence by the length of the argument. If str is null, then
	 * the four characters "null" are appended.
	 * <p>
	 * Let n be the length of this character sequence just prior to execution of the
	 * append method. Then the character at index k in the new character sequence is
	 * equal to the character at index k in the old character sequence, if k is less
	 * than n; otherwise, it is equal to the character at index k-n in the argument
	 * str.
	 *
	 * @param str
	 *            a {@code String}.
	 * @return a reference to this object.
	 */
	public synchronized StringBuffer append(@Nullable String str) {
		throw new RuntimeException();
	}

	/**
	 * Appends the specified <code>StringBuffer</code> to this sequence.
	 * <p>
	 * The characters of the <code>StringBuffer</code> argument are appended, in order, to the contents of
	 * this <code>StringBuffer</code>, increasing the length of this <code>StringBuffer</code> by the length of
	 * the argument. If <code>sb</code> is <code>null</code>, then the four characters <code>"null"</code> are
	 * appended to this <code>StringBuffer</code>.
	 * <p>
	 * Let <i>n</i> be the length of the old character sequence, the one contained in the
	 * <code>StringBuffer</code> just prior to execution of the <code>append</code> method. Then the character
	 * at index <i>k</i> in the new character sequence is equal to the character at index <i>k</i> in
	 * the old character sequence, if <i>k</i> is less than <i>n</i>; otherwise, it is equal to the
	 * character at index <i>k-n</i> in the argument <code>sb</code>.
	 * <p>
	 * This method synchronizes on <code>this</code> (the destination) object but does not synchronize
	 * on the source (<code>sb</code>).
	 *
	 * @param sb
	 *        the <code>StringBuffer</code> to append.
	 * @return a reference to this object.
	 */
	public synchronized StringBuffer append(@Nullable StringBuffer sb) {
		throw new RuntimeException();
	}

	/**
	 * Returns the current capacity. The capacity is the amount of storage available
	 * for newly inserted characters, beyond which an allocation will occur.
	 *
	 * @return the current capacity
	 */
	public synchronized int capacity() {
		throw new RuntimeException();
	}

	/**
	 * Returns the <code>char</code> value in this sequence at the specified index. The first
	 * <code>char</code> value is at index <code>0</code>, the next at index <code>1</code>, and so on,
	 * as in array indexing.
	 * <p>
	 * The index argument must be greater than or equal to <code>0</code>, and less than the length of
	 * this sequence.
	 *
	 * @param index
	 *        the index of the desired <code>char</code> value.
	 * @return the <code>char</code> value at the specified index.
	 * @throws IndexOutOfBoundsException
	 *         if <code>index</code> is negative or greater than or equal to <code>length()</code>.
	 *
	 * @see #length()
	 */
	@Override
	public synchronized char charAt(int index) {
		throw new RuntimeException();
	}

	/**
	 * Removes the characters in a substring of this sequence. The substring begins at the specified
	 * {@code start} and extends to the character at index {@code end - 1} or to the end of the sequence
	 * if no such character exists. If {@code start} is equal to {@code end}, no changes are made.
	 *
	 * @param start
	 *        The beginning index, inclusive.
	 * @param end
	 *        The ending index, exclusive.
	 * @return This object.
	 * @throws StringIndexOutOfBoundsException
	 *         if {@code start} is negative, greater than {@code length()}, or greater than {@code end}.
	 */
	public synchronized StringBuffer delete(int start, int end) {
		throw new RuntimeException();
	}

	/**
	 * Removes the <code>char</code> at the specified position in this sequence. This sequence is
	 * shortened by one <code>char</code>.
	 *
	 * <p>
	 * Note: If the character at the given index is a supplementary character, this method does not
	 * remove the entire character. If correct handling of supplementary characters is required,
	 * determine the number of <code>char</code>s to remove by calling
	 * <code>Character.charCount(thisSequence.codePointAt(index))</code>, where
	 * <code>thisSequence</code> is this sequence.
	 *
	 * @param index
	 *        Index of <code>char</code> to remove
	 * @return This object.
	 * @throws StringIndexOutOfBoundsException
	 *         if the <code>index</code> is negative or greater than or equal to <code>length()</code>.
	 */
	public synchronized StringBuffer deleteCharAt(int index) {
		throw new RuntimeException();
	}

	/**
	 * Ensures that the capacity is at least equal to the specified minimum. If the current capacity is
	 * less than the argument, then a new internal array is allocated with greater capacity. The new
	 * capacity is the larger of:
	 * <ul>
	 * <li>The <code>minimumCapacity</code> argument.
	 * <li>Twice the old capacity, plus <code>2</code>.
	 * </ul>
	 * If the <code>minimumCapacity</code> argument is nonpositive, this method takes no action and
	 * simply returns.
	 *
	 * @param minimumCapacity
	 *        the minimum desired capacity.
	 */
	public synchronized void ensureCapacity(int minimumCapacity) {
		throw new RuntimeException();
	}

	/**
	 * Characters are copied from this sequence into the destination character array <code>dst</code>.
	 * The first character to be copied is at index <code>srcBegin</code>; the last character to be
	 * copied is at index <code>srcEnd-1</code>. The total number of characters to be copied is
	 * <code>srcEnd-srcBegin</code>. The characters are copied into the subarray of <code>dst</code>
	 * starting at index <code>dstBegin</code> and ending at index:
	 * <blockquote>
	 *
	 * <pre>
	 * dstbegin + (srcEnd - srcBegin) - 1
	 * </pre>
	 *
	 * </blockquote>
	 *
	 * @param srcBegin
	 *        start copying at this offset.
	 * @param srcEnd
	 *        stop copying at this offset.
	 * @param dst
	 *        the array to copy the data into.
	 * @param dstBegin
	 *        offset into <code>dst</code>.
	 * @throws NullPointerException
	 *         if <code>dst</code> is <code>null</code>.
	 * @throws IndexOutOfBoundsException
	 *         if any of the following is true:
	 *         <ul>
	 *         <li><code>srcBegin</code> is negative
	 *         <li><code>dstBegin</code> is negative
	 *         <li>the <code>srcBegin</code> argument is greater than the <code>srcEnd</code> argument.
	 *         <li><code>srcEnd</code> is greater than <code>this.length()</code>.
	 *         <li><code>
	 *         dstBegin+srcEnd-srcBegin</code> is greater than <code>dst.length</code>
	 *         </ul>
	 */
	public synchronized void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the first occurrence of the specified substring. The
	 * integer returned is the smallest value <i>k</i> such that: <blockquote>
	 *
	 * <pre>
	 * this.toString().startsWith(str, <i>k</i>)
	 * </pre>
	 *
	 * </blockquote> is <code>true</code>.
	 *
	 * @param str
	 *        any string.
	 * @return if the string argument occurs as a substring within this object, then the index of the
	 *         first character of the first such substring is returned; if it does not occur as a
	 *         substring, <code>-1</code> is returned.
	 * @throws java.lang.NullPointerException
	 *         if <code>str</code> is <code>null</code>.
	 */
	public synchronized int indexOf(String str) {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the first occurrence of the specified substring, starting
	 * at the specified index. The integer returned is the smallest value <code>k</code> for which:
	 * <blockquote>
	 *
	 * <pre>
	 * k &gt;= Math.min(fromIndex, str.length()) &amp;&amp; this.toString().startsWith(str, k)
	 * </pre>
	 *
	 * </blockquote> If no such value of <i>k</i> exists, then -1 is returned.
	 *
	 * @param str
	 *        the substring for which to search.
	 * @param fromIndex
	 *        the index from which to start the search.
	 * @return the index within this string of the first occurrence of the specified substring, starting
	 *         at the specified index.
	 * @throws java.lang.NullPointerException
	 *         if <code>str</code> is <code>null</code>.
	 */
	public synchronized int indexOf(String str, int fromIndex) {
		throw new RuntimeException();
	}

	/**
	 * Inserts the string representation of the {@code boolean} argument into this sequence.
	 * <p>
	 * The overall effect is exactly as if the second argument were converted to a string by the method
	 * {@link String#valueOf(boolean)}, and the characters of that string were then
	 * {@link #insert(int,String) inserted} into this character sequence at the indicated offset.
	 * <p>
	 * The {@code offset} argument must be greater than or equal to {@code 0}, and less than or equal to
	 * the {@linkplain #length() length} of this sequence.
	 *
	 * @param offset
	 *        the offset.
	 * @param b
	 *        a {@code boolean}.
	 * @return a reference to this object.
	 * @throws StringIndexOutOfBoundsException
	 *         if the offset is invalid.
	 */
	public synchronized StringBuffer insert(int offset, boolean b) {
		throw new RuntimeException();
	}

	/**
	 * Inserts the string representation of the {@code char} argument into this sequence.
	 * <p>
	 * The overall effect is exactly as if the second argument were converted to a string by the method
	 * {@link String#valueOf(char)}, and the character in that string were then
	 * {@link #insert(int,String) inserted} into this character sequence at the indicated offset.
	 * <p>
	 * The {@code offset} argument must be greater than or equal to {@code 0}, and less than or equal to
	 * the {@linkplain #length() length} of this sequence.
	 *
	 * @param offset
	 *        the offset.
	 * @param c
	 *        a {@code char}.
	 * @return a reference to this object.
	 * @throws IndexOutOfBoundsException
	 *         if the offset is invalid.
	 */
	public synchronized StringBuffer insert(int offset, char c) {
		throw new RuntimeException();
	}

	/**
	 * Inserts the string representation of the {@code char} array argument into this sequence.
	 * <p>
	 * The characters of the array argument are inserted into the contents of this sequence at the
	 * position indicated by {@code offset}. The length of this sequence increases by the length of the
	 * argument.
	 * <p>
	 * The overall effect is exactly as if the second argument were converted to a string by the method
	 * {@link String#valueOf(char[])}, and the characters of that string were then
	 * {@link #insert(int,String) inserted} into this character sequence at the indicated offset.
	 * <p>
	 * The {@code offset} argument must be greater than or equal to {@code 0}, and less than or equal to
	 * the {@linkplain #length() length} of this sequence.
	 *
	 * @param offset
	 *        the offset.
	 * @param str
	 *        a character array.
	 * @return a reference to this object.
	 * @throws StringIndexOutOfBoundsException
	 *         if the offset is invalid.
	 */
	public synchronized StringBuffer insert(int offset, char[] str) {
		throw new RuntimeException();
	}

	/**
	 * Inserts the string representation of a subarray of the {@code str} array argument into this
	 * sequence. The subarray begins at the specified {@code offset} and extends {@code len}
	 * {@code char}s. The characters of the subarray are inserted into this sequence at the position
	 * indicated by {@code index}. The length of this sequence increases by {@code len} {@code char} s.
	 *
	 * @param index
	 *        position at which to insert subarray.
	 * @param str
	 *        A {@code char} array.
	 * @param offset
	 *        the index of the first {@code char} in subarray to be inserted.
	 * @param len
	 *        the number of {@code char}s in the subarray to be inserted.
	 * @return This object
	 * @throws StringIndexOutOfBoundsException
	 *         if {@code index} is negative or greater than {@code length()}, or {@code offset} or
	 *         {@code len} are negative, or {@code (offset+len)} is greater than {@code str.length}.
	 */
	public synchronized StringBuffer insert(int index, char[] str, int offset, int len) {
		throw new RuntimeException();
	}

	/**
	 * Inserts the specified {@code CharSequence} into this sequence.
	 * <p>
	 * The characters of the {@code CharSequence} argument are inserted, in order, into this sequence at
	 * the indicated offset, moving up any characters originally above that position and increasing the
	 * length of this sequence by the length of the argument s.
	 * <p>
	 * The result of this method is exactly the same as if it were an invocation of this object's
	 * {@link #insert(int,CharSequence,int,int) insert}(dstOffset, s, 0, s.length()) method.
	 *
	 * <p>
	 * If {@code s} is {@code null}, then the four characters {@code "null"} are inserted into this
	 * sequence.
	 *
	 * @param dstOffset
	 *        the offset.
	 * @param s
	 *        the sequence to be inserted
	 * @return a reference to this object.
	 * @throws IndexOutOfBoundsException
	 *         if the offset is invalid.
	 */
	public synchronized StringBuffer insert(int dstOffset, @Nullable CharSequence s) {
		throw new RuntimeException();
	}

	/**
	 * Inserts a subsequence of the specified {@code CharSequence} into this sequence.
	 * <p>
	 * The subsequence of the argument {@code s} specified by {@code start} and {@code end} are
	 * inserted, in order, into this sequence at the specified destination offset, moving up any
	 * characters originally above that position. The length of this sequence is increased by
	 * {@code end - start}.
	 * <p>
	 * The character at index <i>k</i> in this sequence becomes equal to:
	 * <ul>
	 * <li>the character at index <i>k</i> in this sequence, if <i>k</i> is less than {@code dstOffset}
	 * <li>the character at index <i>k</i>{@code +start-dstOffset} in the argument {@code s}, if
	 * <i>k</i> is greater than or equal to {@code dstOffset} but is less than
	 * {@code dstOffset+end-start}
	 * <li>the character at index <i>k</i>{@code -(end-start)} in this sequence, if <i>k</i> is greater
	 * than or equal to {@code dstOffset+end-start}
	 * </ul>
	 * <p>
	 * The {@code dstOffset} argument must be greater than or equal to {@code 0}, and less than or equal
	 * to the {@linkplain #length() length} of this sequence.
	 * <p>
	 * The start argument must be nonnegative, and not greater than {@code end}.
	 * <p>
	 * The end argument must be greater than or equal to {@code start}, and less than or equal to the
	 * length of s.
	 *
	 * <p>
	 * If {@code s} is {@code null}, then this method inserts characters as if the s parameter was a
	 * sequence containing the four characters {@code "null"}.
	 *
	 * @param dstOffset
	 *        the offset in this sequence.
	 * @param s
	 *        the sequence to be inserted.
	 * @param start
	 *        the starting index of the subsequence to be inserted.
	 * @param end
	 *        the end index of the subsequence to be inserted.
	 * @return a reference to this object.
	 * @throws IndexOutOfBoundsException
	 *         if {@code dstOffset} is negative or greater than {@code this.length()}, or {@code start}
	 *         or {@code end} are negative, or {@code start} is greater than {@code end} or {@code end}
	 *         is greater than {@code s.length()}
	 */
	public synchronized StringBuffer insert(int dstOffset, @Nullable CharSequence s, int start, int end) {
		throw new RuntimeException();
	}

	/**
	 * Inserts the string representation of the {@code double} argument into this sequence.
	 * <p>
	 * The overall effect is exactly as if the second argument were converted to a string by the method
	 * {@link String#valueOf(double)}, and the characters of that string were then
	 * {@link #insert(int,String) inserted} into this character sequence at the indicated offset.
	 * <p>
	 * The {@code offset} argument must be greater than or equal to {@code 0}, and less than or equal to
	 * the {@linkplain #length() length} of this sequence.
	 *
	 * @param offset
	 *        the offset.
	 * @param d
	 *        a {@code double}.
	 * @return a reference to this object.
	 * @throws StringIndexOutOfBoundsException
	 *         if the offset is invalid.
	 */
	public synchronized StringBuffer insert(int offset, double d) {
		throw new RuntimeException();
	}

	/**
	 * Inserts the string representation of the {@code float} argument into this sequence.
	 * <p>
	 * The overall effect is exactly as if the second argument were converted to a string by the method
	 * {@link String#valueOf(float)}, and the characters of that string were then
	 * {@link #insert(int,String) inserted} into this character sequence at the indicated offset.
	 * <p>
	 * The {@code offset} argument must be greater than or equal to {@code 0}, and less than or equal to
	 * the {@linkplain #length() length} of this sequence.
	 *
	 * @param offset
	 *        the offset.
	 * @param f
	 *        a {@code float}.
	 * @return a reference to this object.
	 * @throws StringIndexOutOfBoundsException
	 *         if the offset is invalid.
	 */
	public synchronized StringBuffer insert(int offset, float f) {
		throw new RuntimeException();
	}

	/**
	 * Inserts the string representation of the second {@code int} argument into this sequence.
	 * <p>
	 * The overall effect is exactly as if the second argument were converted to a string by the method
	 * {@link String#valueOf(int)}, and the characters of that string were then
	 * {@link #insert(int,String) inserted} into this character sequence at the indicated offset.
	 * <p>
	 * The {@code offset} argument must be greater than or equal to {@code 0}, and less than or equal to
	 * the {@linkplain #length() length} of this sequence.
	 *
	 * @param offset
	 *        the offset.
	 * @param i
	 *        an {@code int}.
	 * @return a reference to this object.
	 * @throws StringIndexOutOfBoundsException
	 *         if the offset is invalid.
	 */
	public synchronized StringBuffer insert(int offset, int i) {
		throw new RuntimeException();
	}

	/**
	 * Inserts the string representation of the {@code long} argument into this sequence.
	 * <p>
	 * The overall effect is exactly as if the second argument were converted to a string by the method
	 * {@link String#valueOf(long)}, and the characters of that string were then
	 * {@link #insert(int,String) inserted} into this character sequence at the indicated offset.
	 * <p>
	 * The {@code offset} argument must be greater than or equal to {@code 0}, and less than or equal to
	 * the {@linkplain #length() length} of this sequence.
	 *
	 * @param offset
	 *        the offset.
	 * @param l
	 *        a {@code long}.
	 * @return a reference to this object.
	 * @throws StringIndexOutOfBoundsException
	 *         if the offset is invalid.
	 */
	public synchronized StringBuffer insert(int offset, long l) {
		throw new RuntimeException();
	}

	/**
	 * Inserts the string representation of the {@code Object} argument into this character sequence.
	 * <p>
	 * The overall effect is exactly as if the second argument were converted to a string by the method
	 * {@link String#valueOf(Object)}, and the characters of that string were then
	 * {@link #insert(int,String) inserted} into this character sequence at the indicated offset.
	 * <p>
	 * The {@code offset} argument must be greater than or equal to {@code 0}, and less than or equal to
	 * the {@linkplain #length() length} of this sequence.
	 *
	 * @param offset
	 *        the offset.
	 * @param obj
	 *        an {@code Object}.
	 * @return a reference to this object.
	 * @throws StringIndexOutOfBoundsException
	 *         if the offset is invalid.
	 */
	public synchronized StringBuffer insert(int offset, Object obj) {
		throw new RuntimeException();
	}

	/**
	 * Inserts the string into this character sequence.
	 * <p>
	 * The characters of the {@code String} argument are inserted, in order, into
	 * this sequence at the indicated offset, moving up any characters originally
	 * above that position and increasing the length of this sequence by the length
	 * of the argument. If {@code str} is {@code null}, then the four characters
	 * {@code "null"} are inserted into this sequence.
	 * <p>
	 * The character at index <i>k</i> in the new character sequence is equal to:
	 * <ul>
	 * <li>the character at index <i>k</i> in the old character sequence, if
	 * <i>k</i> is less than {@code offset}
	 * <li>the character at index <i>k</i>{@code -offset} in the argument
	 * {@code str}, if <i>k</i> is not less than {@code offset} but is less than
	 * {@code offset+str.length()}
	 * <li>the character at index <i>k</i>{@code -str.length()} in the old character
	 * sequence, if <i>k</i> is not less than {@code offset+str.length()}
	 * </ul>
	 * <p>
	 * The {@code offset} argument must be greater than or equal to {@code 0}, and
	 * less than or equal to the {@linkplain #length() length} of this sequence.
	 *
	 * @param offset
	 *            the offset.
	 * @param str
	 *            a {@code String}.
	 * @return a reference to this object.
	 * @throws StringIndexOutOfBoundsException
	 *             if the offset is invalid.
	 */
	public synchronized StringBuffer insert(int offset, @Nullable String str) {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the rightmost occurrence of the specified substring. The
	 * rightmost empty string "" is considered to occur at the index value <code>this.length()</code>.
	 * The returned index is the largest value <i>k</i> such that <blockquote>
	 *
	 * <pre>
	 * this.toString().startsWith(str, k)
	 * </pre>
	 *
	 * </blockquote> is true.
	 *
	 * @param str
	 *        the substring to search for.
	 * @return if the string argument occurs one or more times as a substring within this object, then
	 *         the index of the first character of the last such substring is returned. If it does not
	 *         occur as a substring, <code>-1</code> is returned.
	 * @throws java.lang.NullPointerException
	 *         if <code>str</code> is <code>null</code>.
	 */
	public synchronized int lastIndexOf(String str) {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the last occurrence of the specified substring. The
	 * integer returned is the largest value <i>k</i> such that: <blockquote>
	 *
	 * <pre>
	 * k &lt;= Math.min(fromIndex, str.length()) &amp;&amp; this.toString().startsWith(str, k)
	 * </pre>
	 *
	 * </blockquote> If no such value of <i>k</i> exists, then -1 is returned.
	 *
	 * @param str
	 *        the substring to search for.
	 * @param fromIndex
	 *        the index to start the search from.
	 * @return the index within this sequence of the last occurrence of the specified substring.
	 * @throws java.lang.NullPointerException
	 *         if <code>str</code> is <code>null</code>.
	 */
	public synchronized int lastIndexOf(String str, int fromIndex) {
		throw new RuntimeException();
	}

	@Override
	public synchronized int length() {
		throw new RuntimeException();
	}

	/**
	 * Replaces the characters in a substring of this sequence with characters in the specified
	 * <code>String</code>. The substring begins at the specified <code>start</code> and extends to the
	 * character at index <code>end - 1</code> or to the end of the sequence if no such character
	 * exists. First the characters in the substring are removed and then the specified
	 * <code>String</code> is inserted at <code>start</code>. (This sequence will be lengthened to
	 * accommodate the specified String if necessary.)
	 *
	 * @param start
	 *        The beginning index, inclusive.
	 * @param end
	 *        The ending index, exclusive.
	 * @param str
	 *        String that will replace previous contents.
	 * @return This object.
	 * @throws StringIndexOutOfBoundsException
	 *         if <code>start</code> is negative, greater than <code>length()</code>, or greater than
	 *         <code>end</code>.
	 */
	public synchronized StringBuffer replace(int start, int end, String str) {
		throw new RuntimeException();
	}

	/**
	 * Causes this character sequence to be replaced by the reverse of the sequence.
	 *
	 * Let <i>n</i> be the character length of this character sequence (not the length in
	 * <code>char</code> values) just prior to execution of the <code>reverse</code> method. Then the
	 * character at index <i>k</i> in the new character sequence is equal to the character at index
	 * <i>n-k-1</i> in the old character sequence.
	 *
	 * @return a reference to this object.
	 */
	public synchronized StringBuffer reverse() {
		throw new RuntimeException();
	}

	/**
	 * The character at the specified index is set to <code>ch</code>. This sequence is altered to
	 * represent a new character sequence that is identical to the old character sequence, except that
	 * it contains the character <code>ch</code> at position <code>index</code>.
	 * <p>
	 * The index argument must be greater than or equal to <code>0</code>, and less than the length of
	 * this sequence.
	 *
	 * @param index
	 *        the index of the character to modify.
	 * @param ch
	 *        the new character.
	 * @throws IndexOutOfBoundsException
	 *         if <code>index</code> is negative or greater than or equal to <code>length()</code>.
	 * @see #length()
	 */
	public synchronized void setCharAt(int index, char ch) {
		throw new RuntimeException();
	}

	/**
	 * Sets the length of the character sequence. The sequence is changed to a new character sequence
	 * whose length is specified by the argument. For every nonnegative index <i>k</i> less than
	 * <code>newLength</code>, the character at index <i>k</i> in the new character sequence is the same
	 * as the character at index <i>k</i> in the old sequence if <i>k</i> is less than the length of the
	 * old character sequence; otherwise, it is the null character <code>'&#92;u0000'</code>.
	 *
	 * In other words, if the <code>newLength</code> argument is less than the current length, the
	 * length is changed to the specified length.
	 * <p>
	 * If the <code>newLength</code> argument is greater than or equal to the current length, sufficient
	 * null characters (<code>'&#92;u0000'</code>) are appended so that length becomes the
	 * <code>newLength</code> argument.
	 * <p>
	 * The <code>newLength</code> argument must be greater than or equal to <code>0</code>.
	 *
	 * @param newLength
	 *        the new length
	 * @throws IndexOutOfBoundsException
	 *         if the <code>newLength</code> argument is negative.
	 * @see #length()
	 */
	public synchronized void setLength(int newLength) {
		throw new RuntimeException();
	}

	/**
	 * Returns a new character sequence that is a subsequence of this sequence.
	 *
	 * <p>
	 * An invocation of this method of the form
	 *
	 * <blockquote>
	 *
	 * <pre>
	 * sb.subSequence(begin, end)
	 * </pre>
	 *
	 * </blockquote>
	 *
	 * behaves in exactly the same way as the invocation
	 *
	 * <blockquote>
	 *
	 * <pre>
	 * sb.substring(begin, end)
	 * </pre>
	 *
	 * </blockquote>
	 *
	 * This method is provided so that this class can implement the {@link CharSequence} interface.
	 *
	 * @param start
	 *        the start index, inclusive.
	 * @param end
	 *        the end index, exclusive.
	 * @return the specified subsequence.
	 *
	 * @throws IndexOutOfBoundsException
	 *         if <code>start</code> or <code>end</code> are negative, if <code>end</code> is greater than
	 *         <code>length()</code>, or if <code>start</code> is greater than <code>end</code>
	 */
	@Override
	public synchronized CharSequence subSequence(int start, int end) {
		throw new RuntimeException();
	}

	/**
	 * Returns a new <code>String</code> that contains a subsequence of characters currently contained
	 * in this character sequence. The substring begins at the specified index and extends to the end of
	 * this sequence.
	 *
	 * @param start
	 *        The beginning index, inclusive.
	 * @return The new string.
	 * @throws StringIndexOutOfBoundsException
	 *         if <code>start</code> is less than zero, or greater than the length of this object.
	 */
	public synchronized String substring(int start) {
		throw new RuntimeException();
	}

	/**
	 * Returns a new <code>String</code> that contains a subsequence of characters currently contained
	 * in this sequence. The substring begins at the specified <code>start</code> and extends to the
	 * character at index <code>end - 1</code>.
	 *
	 * @param start
	 *        The beginning index, inclusive.
	 * @param end
	 *        The ending index, exclusive.
	 * @return The new string.
	 * @throws StringIndexOutOfBoundsException
	 *         if <code>start</code> or <code>end</code> are negative or greater than
	 *         <code>length()</code>, or <code>start</code> is greater than <code>end</code>.
	 */
	public synchronized String substring(int start, int end) {
		throw new RuntimeException();
	}

	@Override
	public synchronized String toString() {
		throw new RuntimeException();
	}

	/**
	 * Attempts to reduce storage used for the character sequence. If the buffer is larger than
	 * necessary to hold its current sequence of characters, then it may be resized to become more space
	 * efficient. Calling this method may, but is not required to, affect the value returned by a
	 * subsequent call to the {@link #capacity()} method.
	 */
	public synchronized void trimToSize() {
		throw new RuntimeException();
	}

}
