package java.util;

import ej.annotation.Nullable;

/**
 * The class <code>Date</code> represents a specific instant in time, with millisecond precision.
 * <p>
 * Although the <code>Date</code> class is intended to reflect coordinated universal time (UTC), it
 * may not do so exactly, depending on the host environment of the Java Virtual Machine. Nearly all
 * modern operating systems assume that 1&nbsp;day&nbsp;=
 * 24&nbsp;&times;&nbsp;60&nbsp;&times;&nbsp;60&nbsp;= 86400 seconds in all cases. In UTC, however,
 * about once every year or two there is an extra second, called a "leap second." The leap second is
 * always added as the last second of the day, and always on December 31 or June 30. For example,
 * the last minute of the year 1995 was 61 seconds long, thanks to an added leap second. Most
 * computer clocks are not accurate enough to be able to reflect the leap-second distinction.
 * <p>
 * Some computer standards are defined in terms of Greenwich mean time (GMT), which is equivalent to
 * universal time (UT). GMT is the "civil" name for the standard; UT is the "scientific" name for
 * the same standard. The distinction between UTC and UT is that UTC is based on an atomic clock and
 * UT is based on astronomical observations, which for all practical purposes is an invisibly fine
 * hair to split. Because the earth's rotation is not uniform (it slows down and speeds up in
 * complicated ways), UT does not always flow uniformly. Leap seconds are introduced as needed into
 * UTC so as to keep UTC within 0.9 seconds of UT1, which is a version of UT with certain
 * corrections applied. There are other time and date systems as well; for example, the time scale
 * used by the satellite-based global positioning system (GPS) is synchronized to UTC but is
 * <i>not</i> adjusted for leap seconds. An interesting source of further information is the U.S.
 * Naval Observatory, particularly the Directorate of Time at: <blockquote>
 *
 * <pre>
 *     <a href=http://tycho.usno.navy.mil>http://tycho.usno.navy.mil</a>
 * </pre>
 *
 * </blockquote>
 * <p>
 * and their definitions of "Systems of Time" at: <blockquote>
 *
 * <pre>
 *     <a href=http://tycho.usno.navy.mil/systime.html>http://tycho.usno.navy.mil/systime.html</a>
 * </pre>
 *
 * </blockquote>
 * <p>
 * In all methods of class <code>Date</code> that accept or return year, month, date, hours,
 * minutes, and seconds values, the following representations are used:
 * <ul>
 * <li>A year <i>y</i> is represented by the integer <i>y</i>&nbsp; <code>-&nbsp;1900</code>.
 * <li>A month is represented by an integer from 0 to 11; 0 is January, 1 is February, and so forth;
 * thus 11 is December.
 * <li>A date (day of month) is represented by an integer from 1 to 31 in the usual manner.
 * <li>An hour is represented by an integer from 0 to 23. Thus, the hour from midnight to 1 a.m. is
 * hour 0, and the hour from noon to 1 p.m. is hour 12.
 * <li>A minute is represented by an integer from 0 to 59 in the usual manner.
 * <li>A second is represented by an integer from 0 to 61; the values 60 and 61 occur only for leap
 * seconds and even then only in Java implementations that actually track leap seconds correctly.
 * Because of the manner in which leap seconds are currently introduced, it is extremely unlikely
 * that two leap seconds will occur in the same minute, but this specification follows the date and
 * time conventions for ISO C.
 * </ul>
 * <p>
 * In all cases, arguments given to methods for these purposes need not fall within the indicated
 * ranges; for example, a date may be specified as January 32 and is interpreted as meaning February
 * 1.
 *
 * @see java.util.Calendar
 * @see java.util.TimeZone
 */
public class Date implements java.io.Serializable, Cloneable, Comparable<Date> {
	/**
	 * Allocates a <code>Date</code> object and initializes it so that it represents the time at which
	 * it was allocated, measured to the nearest millisecond.
	 *
	 * @see java.lang.System#currentTimeMillis()
	 */
	public Date() {
		throw new RuntimeException();
	}

	/**
	 * Allocates a <code>Date</code> object and initializes it to represent the specified number of
	 * milliseconds since the standard base time known as "the epoch", namely January 1, 1970, 00:00:00
	 * GMT.
	 *
	 * @param date
	 *        the milliseconds since January 1, 1970, 00:00:00 GMT.
	 * @see java.lang.System#currentTimeMillis()
	 */
	public Date(long date) {
		throw new RuntimeException();
	}

	/**
	 * Tests if this date is after the specified date.
	 *
	 * @param when
	 *        a date.
	 * @return <code>true</code> if and only if the instant represented by this <tt>Date</tt> object is
	 *         strictly later than the instant represented by <tt>when</tt>; <code>false</code>
	 *         otherwise.
	 * @exception NullPointerException
	 *            if <code>when</code> is null.
	 */
	public boolean after(Date when) {
		throw new RuntimeException();
	}

	/**
	 * Tests if this date is before the specified date.
	 *
	 * @param when
	 *        a date.
	 * @return <code>true</code> if and only if the instant of time represented by this <tt>Date</tt>
	 *         object is strictly earlier than the instant represented by <tt>when</tt>;
	 *         <code>false</code> otherwise.
	 * @exception NullPointerException
	 *            if <code>when</code> is null.
	 */
	public boolean before(Date when) {
		throw new RuntimeException();
	}

	/**
	 * Return a copy of this object.
	 */
	@Override
	public Object clone() {
		throw new RuntimeException();
	}

	/**
	 * Compares two Dates for ordering.
	 *
	 * @param anotherDate
	 *        the <code>Date</code> to be compared.
	 * @return the value <code>0</code> if the argument Date is equal to this Date; a value less than
	 *         <code>0</code> if this Date is before the Date argument; and a value greater than
	 *         <code>0</code> if this Date is after the Date argument.
	 * @exception NullPointerException
	 *            if <code>anotherDate</code> is null.
	 */
	@Override
	public int compareTo(Date anotherDate) {
		throw new RuntimeException();
	}

	/**
	 * Compares two dates for equality. The result is <code>true</code> if and only if the argument is
	 * not <code>null</code> and is a <code>Date</code> object that represents the same point in time,
	 * to the millisecond, as this object.
	 * <p>
	 * Thus, two <code>Date</code> objects are equal if and only if the <code>getTime</code> method
	 * returns the same <code>long</code> value for both.
	 *
	 * @param obj
	 *        the object to compare with.
	 * @return <code>true</code> if the objects are the same; <code>false</code> otherwise.
	 * @see java.util.Date#getTime()
	 */
	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	/**
	 * Returns the number of milliseconds since January 1, 1970, 00:00:00 GMT represented by this
	 * <tt>Date</tt> object.
	 *
	 * @return the number of milliseconds since January 1, 1970, 00:00:00 GMT represented by this date.
	 */
	public long getTime() {
		throw new RuntimeException();
	}

	/**
	 * Returns a hash code value for this object. The result is the exclusive OR of the two halves of
	 * the primitive <tt>long</tt> value returned by the {@link Date#getTime} method. That is, the hash
	 * code is the value of the expression: <blockquote>
	 *
	 * <pre>
	 * (int) (this.getTime() &circ; (this.getTime() &gt;&gt;&gt; 32))
	 * </pre>
	 *
	 * </blockquote>
	 *
	 * @return a hash code value for this object.
	 */
	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	/**
	 * Sets this <code>Date</code> object to represent a point in time that is <code>time</code>
	 * milliseconds after January 1, 1970 00:00:00 GMT.
	 *
	 * @param time
	 *        the number of milliseconds.
	 */
	public void setTime(long time) {
		throw new RuntimeException();
	}

	/**
	 * Converts this <code>Date</code> object to a <code>String</code> of the form: <blockquote>
	 *
	 * <pre>
	 * dow mon dd hh:mm:ss zzz yyyy
	 * </pre>
	 *
	 * </blockquote> where:
	 * <ul>
	 * <li><tt>dow</tt> is the day of the week (<tt>Sun, Mon, Tue, Wed,
	 *     Thu, Fri, Sat</tt>).
	 * <li><tt>mon</tt> is the month (<tt>Jan, Feb, Mar, Apr, May, Jun,
	 *     Jul, Aug, Sep, Oct, Nov, Dec</tt>).
	 * <li><tt>dd</tt> is the day of the month (<tt>01</tt> through <tt>31</tt> ), as two decimal
	 * digits.
	 * <li><tt>hh</tt> is the hour of the day (<tt>00</tt> through <tt>23</tt>), as two decimal digits.
	 * <li><tt>mm</tt> is the minute within the hour (<tt>00</tt> through <tt>59</tt>), as two decimal
	 * digits.
	 * <li><tt>ss</tt> is the second within the minute (<tt>00</tt> through <tt>61</tt>, as two decimal
	 * digits.
	 * <li><tt>zzz</tt> is the time zone (and may reflect daylight saving time). Standard time zone
	 * abbreviations include those recognized by the method <tt>parse</tt>. If time zone information is
	 * not available, then <tt>zzz</tt> is empty - that is, it consists of no characters at all.
	 * <li><tt>yyyy</tt> is the year, as four decimal digits.
	 * </ul>
	 *
	 * @return a string representation of this date.
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}

}
