/*
 * Java
 *
 * Copyright 2018-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.aws.iot;

/**
 * The callback interface when receiving messages from AWS IoT.
 *
 * This can be used when subscribing to a topic, all the messages received on that specific topic will be routed to this
 * callback.
 */
public interface AwsIotMessageCallback {

	/**
	 * Called whenever a message arrives in the broker.
	 *
	 *
	 * @param message
	 *            received AWS IoT message
	 */
	void onMessageReceived(AwsIotMessage message);

}
