/*
 * Java
 *
 * Copyright 2021-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.aws.iot;

import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 * Internal AwsIotClientCallback
 */
class AwsIotClientCallback implements MqttCallback {

	private final AwsIotClient client;

	protected AwsIotClientCallback(AwsIotClient client) {
		this.client = client;
	}

	@Override
	public void messageArrived(final String topic, final MqttMessage mqttMessage) throws Exception {
		final AwsIotMessage message = new AwsIotMessage(topic, mqttMessage.getQos(), mqttMessage.isRetained(),
				mqttMessage.getPayload());
		this.client.dispatch(message);
	}

	@Override
	public void connectionLost(Throwable cause) {
		this.client.connectionLost(cause);
	}
}
