/*
 * 2011-2019 ESR - Not subject to Copyright.
 *
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.bon;

import java.util.Hashtable;

/**
 * A {@link Hashtable} implementation with <em>weak keys</em>. An entry in a
 * {@link WeakHashtable} will automatically be removed when its key is no longer
 * in ordinary use. More precisely, the presence of a mapping for a given key
 * will not prevent the key from being discarded by the garbage collector and
 * then reclaimed. When a key has been discarded its entry is effectively
 * removed from the hashtable, so this class behaves somewhat differently from
 * {@link Hashtable} implementation.
 *
 * <p>
 * Each key object in a {@link WeakHashtable} is stored indirectly as the
 * referent of a weak reference. Therefore a key will automatically be removed
 * only after the weak references to it, both inside and outside of the map,
 * have been cleared by the garbage collector.
 *
 * <p>
 * <strong>Implementation note:</strong> The value objects in a
 * {@link WeakHashtable} are held by ordinary strong references. Thus care
 * should be taken to ensure that value objects do not strongly refer to their
 * own keys, either directly or indirectly, since that will prevent the keys
 * from being discarded.
 */
public class WeakHashtable extends Hashtable {

	/**
	 * Constructs a new, empty weak hashtable with a default capacity and load
	 * factor.
	 */
	public WeakHashtable() {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new, empty weak hashtable with the specified initial capacity.
	 * 
	 * @param initialCapacity
	 *            the initial capacity of the hashtable.
	 */
	public WeakHashtable(int initialCapacity) {
		throw new RuntimeException();
	}

}
