/*
 * Java
 *
 * Copyright 2010-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.sni;

public class SNI {

	/**
	 * Transforms a Java String into a C String.<br>
	 * The platform default encoding is used to transform Java characters into C characters.<br>
	 * The created C String is a NULL terminated String (ends with '\0'). The <code>cString</code> array length
	 * must be at least <code>javaString.length()+1</code>.
	 * 
	 * @param javaString the Java String to convert.
	 * @param cString byte array which contains the C String.
	 * 
	 * @throws IllegalArgumentException if javaString or cString is null.
	 * @throws ArrayIndexOutOfBoundsException if cString is too small to contain the string.
	 */
	public static void toCString(String javaString, byte[] cString) {
		throw new RuntimeException() ;
	}

	/**
	 * Transforms a Java String into a C String.<br>
	 * The platform default encoding is used to transform Java characters into C characters.<br>
	 * The returned C String is a NULL terminated String (ends with '\0').
	 * 
	 * @param javaString the Java String to convert.
	 * 
	 * @return a new array that contains the C String representation of the given Java String.
	 * 
	 * @throws IllegalArgumentException if javaString is null.
	 */
	public static byte[] toCString(String javaString) {
		throw new RuntimeException() ;
	}

	/**
	 * Transforms a C String into a Java String,
	 * using platform default encoding.
	 * The C String must be NULL terminated.
	 * 
	 * @param cString byte array which contains the C String.
	 * @return a new Java String.
	 * 
	 * @throws IllegalArgumentException if cString is null or its length is &lt; 1.
	 * @throws IllegalArgumentException if cString is not NULL terminated.
	 */
	public static String toJavaString(byte[] cString) {
		throw new RuntimeException() ;
	}
}
