package java.lang;

/**
 * Thrown if an application attempts to access or modify a field, or to call a method that it does
 * not have access to.
 * <p>
 * Normally, this error is caught by the compiler; this error can only occur at run time if the
 * definition of a class has incompatibly changed.
 */
public class IllegalAccessError extends IncompatibleClassChangeError {

	/**
	 * Constructs an <code>IllegalAccessError</code> with no detail message.
	 */
	public IllegalAccessError() {
		throw new RuntimeException();
	}

	/**
	 * Constructs an <code>IllegalAccessError</code> with the specified detail message.
	 * 
	 * @param s
	 *        the detail message.
	 */
	public IllegalAccessError(String s) {
		throw new RuntimeException();
	}
}
