/*
 * Copyright 2016-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.stylesheet.selector;

import ej.annotation.Nullable;
import ej.mwt.Widget;

/**
 * A type selector selects by checking the widget type (Java class).
 * <p>
 * Equivalent to <code>widget</code> selector in CSS. Its specificity is (0,0,0,1).
 *
 * @see Object#getClass()
 * @see SelectorHelper
 */
public class StrictTypeSelector implements Selector {

	private final Class<? extends Widget> type;

	/**
	 * Creates a type selector.
	 *
	 * @param type
	 *            the widget subtype to check.
	 */
	public StrictTypeSelector(Class<? extends Widget> type) {
		this.type = type;
	}

	@Override
	public boolean appliesToWidget(Widget widget) {
		return widget.getClass() == this.type;
	}

	@Override
	public int getSpecificity() {
		return SelectorHelper.getSpecificity(0, 0, 0, 1);
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		if (obj instanceof StrictTypeSelector) {
			return ((StrictTypeSelector) obj).type == this.type;
		}
		return false;
	}

	@Override
	public int hashCode() {
		return this.type.hashCode();
	}
}
