# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.10.1] - 2024-08-23

### Fixed

  - Backward compatibility with tests generated with JUnit prior to 1.10.0. 

## [1.10.0] - 2024-06-27

### Added

  - Handle skipped tests.

### Changed

  - Report each test separately in the report files.

### Fixed

  -  `_AllTestClasses.java` not generated in the right directory.
  - Call super class tests when they exist.
  - Eclipse errors during build when tests use UTF-8 characters.

## [1.9.0] - 2024-05-21

### Changed

  - Make test file generation incremental.

## [1.8.0] - 2024-04-11

### Added

  - Handle assumption violations.

## [1.7.1] - 2020-05-11

### Fixed

  - Fix non generated call to SimpleTestMethods in the generated "_AllTests_MyClassTest.java" files.

## [1.7.0] - 2020-05-06

### Added

  - @RepeatedTest(value) annotation that repeats a test a number of time equals to the value.

## [1.6.2] - 2020-01-17

### Fixed

  - Fixed NullPointerException when a class has no import declaration.

## [1.6.1] - 2019-12-18

### Fixed

  - Empty parent class now gives access to grandparent annotated methods for child class.
  - Annotation @Test() with empty parenthesis error.

## [1.6.0] - 2019-12-10

### Added

  - Parent classes annotated methods taken into account by subclasses.

## [1.5.0] - 2019-03-12

### Fixed

  - use MMM.

## [1.4.1] - 2018-09-14

### Fixed

  - Generation fails with ArrayIndexOutOfBoundsException when tests are in several packages.

## [1.4.0] - 2018-09-07

### Added

  - Generate class that runs all tests from all classes.	

## [1.3.0] - 2017-09-06

### Added

  - Improved Wrapper API and generated code so it can be used from apps, possibly through a SharedInterface.	

## [1.2.1] - 2017-08-08

### Fixed

  - WI20069 JUnit @Test(expected=...) not importing class in generated wrappers. 	

## [1.2.0] - 2017-04-27

### Fixed

  - WI19630 Split the runTestMethods method.

## [1.1.4] - 2017-03-21

### Added

  - WI19204 Remove warnings to generate source code.

## [1.1.3] - 2017-03-01

### Fixed

  - WI19204 JUnit Addon Preprocessor: error when Java source of a test is not valid.

## [1.1.2] - 2017-02-13

### Fixed

  - WI19077 Missing package declaration in generated test classes.

## [1.1.1] - 2017-02-09

### Fixed

  - WI18758 NullPointer exceptions for tests in default package.
  
### Added

  - WI18782 Add support for Ignore annotation.

## [1.1.0] - 2017-01-25

### Added

  - WI18782 Add support for Ignore annotation.

## [1.0.2] - 2016-16-26

### Fixed

  - WI18427 Use NameEpr.getName() to find the simple name of the annotation.

## [1.0.1] - 2016-11-02

### Fixed

  - Fixed packaging to include dependencies in the .adp file.
   
## [1.0.0] - 2016-10-24

### Added

  - Initial revision.
  
---  
_Copyright 2016-2024 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
