# Overview

MicroEJ Java library: websocket. 

Implementation for the client side of the WebSocket protocol as described in RFC 6455. 
Features:

  - Text message support.
  - Binary message support.
  - UTF8 Validation.
  - Fragmented message.
  
Limitation

  - No support of very extended length.
  - No support of masked frame.
  - No support of proxies.
  - No validation of the nonce.
  
# Usage

Add the following line to your `module.ivy`:
	
    <dependency org="ej.library.iot" name="websocket" rev="2.1.0"/>

## Debug

To enable the log call Messages.log(true), see ej.websocket.Messages for the messages signification.

## Running the autobahn fuzzy server locally

1. Go to the configuration file test.properties.list and enable following server: SERVER_ADDRESS=localhost, SERVER_PORT=9001
2. Install docker.
3. Execute: `docker pull crossbario/autobahn-testsuite:0.8.2`. For some more details see here: https://hub.docker.com/r/crossbario/autobahn-testsuite/tags/
4. Create 2 new directories in the directory from which you will start the server. They will be mounted to the server container when starting the server.
	a. directory: reports. The test reports will be written here by the autobahn fuzzy server.
	b. directory: config. Put here the json file configuring a fuzzy server. You can take this one: https://github.com/crossbario/autobahn-testsuite/blob/master/docker/config/fuzzingserver.json, or the settings file fuzzingserver.json used by microEJ. 	
5. Start the server with this command: 
    * Windows: docker run -it --rm -v %cd%\config:/config -v %cd%\reports:/reports -p 9001:9001 crossbario/autobahn-testsuite wstest -m fuzzingserver -s /config/fuzzingserver.json
    * Linux: docker run -it --rm -v {PWD}\config:/config -v {PWD}\reports:/reports -p 9001:9001 crossbario/autobahn-testsuite wstest -m fuzzingserver -s /config/fuzzingserver.json
6. Server is now running under port 9001.
7. Execute `Build module` in the ej.websocket project.
8. The project will be built, and the tests will be run as one of the final steps.
9. Last run time for the whole building was: 3 minutes 23 seconds.


	
# Requirements

This library requires the following Foundation Libraries:

    BON-1.4, EDC-1.3, NET-1.0-API-1.0

# Dependencies

_All dependencies are retrieved transitively by Ivy resolver_.

# Source

N/A

# Restrictions

None.

---
_Copyright 2019-2025 MicroEJ Corp._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
