# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.3.6] - 2024-01-03

### Added

  - Update the `NonNullByDefault` annotation to be supported by IntelliJ IDEA.
  - Update javadoc comments for HTML 5 compliance.

### Fixed

  - Remove examples of base type class usage (`byte.class.getName()` in `java.lang.Class`).
  - Fix broken links in Javadoc.
  - Add missing inherited `Nullable` annotations:
    - `java.util.AbstractMap.SimpleEntry.setValue(Object)`
    - `java.util.AbstractMap.SimpleImmutableEntry.setValue(Object)`
    - `java.util.WeakHashMap.remove(Object)`

## [1.3.5] - 2022-03-14

### Changed

  - Migrate module to MMM

### Added

  - Add documentation on missing parameterized types
  
### Fixed

  - Fix Javadoc style build without warnings

## [1.3.4] - 2021-06-21

### Fixed

  - Clarify `java.lang.System.gc()` behaviour (remove "thread" notion).

## [1.3.3] - 2020-09-25

### Deprecated

  - Deprecate `java.util.Timer` and `java.util.TimerTask` (prefer `ej.bon.Timer` and `ej.bon.TimerTask` from BON specification)

### Fixed

  - Fix `java.util.List.get()` cannot return a `@Nullable` object
  - Fix `java.util.Map.Entry.getKey()` and `java.util.Map.Entry.getValue()` cannot return a `@Nullable` object
  - Fix declaration of `NonNullByDefault(true)` annotation on `java.lang` & `java.lang.annotation` packages to avoid Eclipse 2020 JDT builder random crashes when Null Analysis is enabled

## [1.3.2] - 2020-06-09

### Fixed

  - Add missing `@Nullable` annotation to `java.io.FilterInputStream.in` field

## [1.3.1] - 2020-03-17

### Fixed

  - Clarify lenient mode support in `java.util.Calendar` class: only lenient mode is supported
  - Add missing `@throws SecurityException` to `java.lang.Thread.interrupt()` method
  - Clarify which methods can be interrupted by `java.lang.Thread.interrupt()` method

## [1.3.0] - 2019-06-03

### Changed

  - Mark APIs for Null Analysis, except the Collections Framework
  - Update templates for `CHANGELOG.md` and `README.md`

### Added

  - Add annotations `ej.annotation.NonNull`, `ej.annotation.NonNullByDefault` and `ej.annotation.Nullable` for Null Analysis
  - Add methods `java.lang.Thread.setDaemon(boolean)` and `java.lang.Thread.isDaemon()`
  - Add methods `java.lang.StringBuilder.substring(int)` and `java.lang.StringBuilder.substring(int,int)`

### Fixed

  - Fix malformed Javadoc comments

## [1.2.3] - 2016-04-01

### Added

  - Initial public revision.