# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.9.0] - (2025-03-28)

### Changed
  - Ensure that the VM thread is suspended during the following native calls:
    - `LLSEC_KEY_PAIR_GENERATOR_IMPL_generateKeyPair()`
    - `LLSEC_SECRET_KEY_FACTORY_IMPL_get_key_data()`
    - `LLSEC_RSA_CIPHER_IMPL_decrypt()`
    - `LLSEC_RSA_CIPHER_IMPL_encrypt()`
    - `LLSEC_SIG_IMPL_sign()`
    - `LLSEC_SIG_IMPL_verify()`

    The tests succeed if a background thread can run or if the call does not take longer than 'com.microej.security.test.ensureasync.thresholdms' property (10ms by default)
  - Refactor SecretFactoryTest to test the comma-separated list of algorithms defined in the 'security.secretfactory.algorithms' property
  - Trigger garbage collector during `KeyPairGeneratorTest.testECValidateGeneratedKeyPairEncoding()` to verify that shared native resources between NativePrivateKey and NativePublicKey are not closed as long as they are referenced.

## [1.8.0] - 2024-01-28

### Added

  - MacTest: add SHA1 and MD5 tests
  - Add CertificateDataTest to test getting subject & issuer names from X509 certificates.

## [1.7.0] - 2024-02-19

### Changed

  - Renamed CipherTest.java to AESCipherTest.java

### Added

  - Added DESede cipher tests.
  - Added PKCS12 PBE cipher tests.
  - Added PBES2 cipher tests.
  - Extended RSA cipher tests with OAEP parameters.
  - Extended AES and DESede tests to support cipher usage without explicit re-initialization.

## [1.6.0] - 2023-10-11

### Added

  - Added test `CertificateTest#checkValidityDoesNotThrowExceptionForValidCertificate()`.
  - Added test `CertificateTest#checkValidityThrowsExceptionForCertificateNotYetValid()`.
  - Added test `CertificateTest#checkValidityThrowsExceptionForExpiredCertificate()`.

## [1.5.0] - 2023-10-16

### Added

  - PBKDF2 tests.

## [1.4.1] - 2023-10-09

### Changed

  - Add delays to prevent the watchdog from terminating the long running tests prematurely
  - Update the module license to BSD MicroEJ version 1.2

## [1.4.0] - 2023-04-11

### Changed

  - Change organization name to `com.microej.pack.net`.

### Added

  - Add RSA cipher tests.

## [1.3.1] - 2022-08-30

### Fixed

 - Upgrade fix version for ej.api.security.

## [1.3.0] - 2022-08-19

### Added

  - Message digest tests.

### Changed

  - Change license to BSD-like license.
  - Skeleton updated with SDK 5.5.
  - Use module in a PQT project.

### Fixed

  - Fix typo in KeyPairGeneratorTest properties.
  - Fix doFinal() return value not used in testMac.

## [1.2.0] - 2021-10-07

### Added

  - KeyPairGeneratorTest covering key pair generation capabilities for RSA and EC.

### Changed

  - Upgrade ej.api#security to 1.4.0.

## [1.1.1] - 2021-06-15

### Added

  - Add PEM Certificate test.
  - Fix test classes compilation. the src/main/java folder is required
  - Convert to MMM 5 format.

## [1.1.0] - 2020-01-28

### Added

  - Add SHA-512 Security testsuite tests.
  - Add Certificate tests.
  - Add tests for Cipher without IV.

## [1.0.0] - 2019-02-07

### Added

  - Initial revision.

---

_Copyright 2018-2025 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
