# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## 2.3.0 - 2023-05-02

### Added
  - Add support for read blob requests.
  - Add support for long write requests.

### Changed
  - Update LLAPI dependency to 2.1.0.
  - Update API dependency to 2.2.0.
  - Update to BSD license.

## 2.2.1 - 2021-10-04

### Fixed
  - Make sure KF implementation is in application classpath.

## 2.2.0 - 2021-09-03

### Added
  - Add KF support.
  - Add KF testsuite.

### Changed
  - Update LLAPI dependency to 2.0.2.

### Fixed
  - Add missing mandatory public confs.

## 2.1.0 - 2020-11-27

### Added
  - Support Bluetooth API 2.1.

### Changed
  - Rename `STANDARD_UUID` immutable to `BASE_UUID`.

## 2.0.1 - 2020-11-17

### Added
  - Add LLAPI to the rip build.

## 2.0.0 - 2020-05-04

### Added
  - Set name of pump thread for debug.
  - Add annotations for null analysis.
  - Add license file.

### Changed
  - Support Bluetooth API 2.0.
  - Rename `BluetoothSNI` to `BluetoothNatives`.
  - Move tools package.
  - Use non-immortal buffers to call native methods (requires SNI 1.3).
  - Rename `bluetooth.events.buffer.size` property to `bluetooth.pump.buffer.size`.
  - Change module organization.

### Removed
  - Remove `bluetooth.natives.buffer.size` property.
  - Remove LLAPI from the rip.

### Fixed
  - Fix exception when passing negative integer to `BluetoothUuid` constructor.
  - Catch all exceptions when calling user code.
  - Decrease heap usage.

## 1.0.3 - 2019-10-10

### Fixed
  - Fix UUIDs serialization and deserialization.

## 1.0.2 - 2019-07-15

### Fixed
  - Fix KF exception in switch statement on enum object.
  - Fix properties initialization in bluetooth-init script.

## 1.0.1 - 2019-07-03

### Changed
  - Use two distinct properties for natives buffer size and events buffer size.

## 1.0.0 - 2019-03-12

### Added
  - Scan nearby devices.
  - Advertise to nearby devices.
  - Connect to and disconnect from a device.
  - Pair with a device.
  - Reply to a pairing request from a device.
  - Provide GATT services.
  - Discover the GATT services provided by a device.
  - Read or write a characteristic or descriptor of a device.
  - Reply to a read or write request from a device.
  - Send characteristic notifications and indications to a device.

---
_Copyright 2018-2023 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
