/*
 * Java
 *
 * Copyright 2012-2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.event.generator;

import ej.microui.event.Event;
import ej.microui.event.EventGenerator;

/**
 * A states event generator is usually associated to a group of physical devices holding a position (switch, rotary
 * wheel encoder, ...) and allows to generate events relating to them. This class generates {@link Event#STATE} events
 * and allows to retrieve for each state its current value. Each instance can manage at most <code>256</code> states and
 * each state can have a value between <code>0</code> and <code>255</code>.<br>
 * A state has a unique ID between <code>0</code> and <code>{@link #getNumberOfStates()}-1</code>
 */
public class States extends EventGenerator {

	/**
	 * Gets the state's ID held by the state event.
	 *
	 * @param event
	 *            the state event to decode.
	 *
	 * @return id between <code>0</code> and <code>255</code>.
	 */
	public static int getStateID(int event) {
		throw new RuntimeException();
	}

	/**
	 * Gets the state's value held by the state event.
	 *
	 * @param event
	 *            the state event to decode.
	 *
	 * @return value between <code>0</code> and <code>255</code>.
	 */
	public static int getStateValue(int event) {
		throw new RuntimeException();
	}

	/**
	 * Creates a states generator.
	 *
	 * @param nbValues
	 *            number of values for each state.
	 * @param initialValues
	 *            initial value for each state.
	 * @throws NullPointerException
	 *             if one of the parameters is null.
	 * @throws IllegalArgumentException
	 *             if both arrays don't have the same length.
	 * @throws IndexOutOfBoundsException
	 *             if arrays length is greater than 255.
	 * @throws IndexOutOfBoundsException
	 *             if <code>nbValues[i] &lt; 0</code> or <code>nbValues[i] &gt; 255</code>.
	 * @throws IndexOutOfBoundsException
	 *             if <code>initialValues[i] &lt; 0</code> or <code>initialValues[i] &gt;= nbValues[i]</code>.
	 */
	public States(int[] nbValues, int[] initialValues) {
		throw new RuntimeException();
	}

	/**
	 * Gets the event type associated with the event generator.
	 *
	 * @return the event type.
	 */

	@Override
	public int getEventType() {
		throw new RuntimeException();
	}

	/**
	 * Gets the total number of values for the given state.
	 *
	 * @param stateID
	 *            the state identifier value.
	 * @return the total number of values for the given state.
	 *
	 * @throws IndexOutOfBoundsException
	 *             when stateID is out of <code>[0,{@link #getNumberOfStates()}-1]</code>.
	 */
	public int getNumberOfValues(int stateID) {
		throw new RuntimeException();
	}

	/**
	 * Gets the current value of the given state.
	 *
	 * @param stateID
	 *            the state identifier value.
	 * @return a number between <code>0</code> and <code>{@link #getNumberOfValues(int)}-1</code>.
	 * @throws IndexOutOfBoundsException
	 *             when stateID is out of <code>[0,{@link #getNumberOfStates()}-1]</code>.
	 */
	public int getCurrentValue(int stateID) {
		throw new RuntimeException();
	}

	/**
	 * Gets the number of states managed by this instance.
	 *
	 * @return the number of states managed by this instance.
	 */
	public int getNumberOfStates() {
		throw new RuntimeException();
	}

	/**
	 * Stores the given state value and sends a MicroUI {@link ej.microui.event.Event#STATE} to the States's listener.
	 *
	 * @param stateID
	 *            the state identifier value.
	 * @param value
	 *            the new state value
	 * @throws IndexOutOfBoundsException
	 *             when <code>stateID</code> is out of <code>[0,{@link #getNumberOfStates()}-1]</code>.
	 * @throws IndexOutOfBoundsException
	 *             when <code>value</code> is out of <code>[0,{@link #getNumberOfValues(int)}-1]</code>.
	 */
	public void send(int stateID, int value) {
		throw new RuntimeException();
	}
}
