/*
 *	Java
 *	
 *	Copyright 2010-2015 IS2T. All rights reserved.
 *	IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package ej.microui.display;

/**
 * The interface <code>Colors</code> provides useful constants to handle RGB colors format. <br>
 * <br>
 * RGB colors format is as follow:<br>
 * | color's red level (<code>8-bit</code>) | color's green level (<code>8-bit</code>) | color's blue level (
 * <code>8-bit</code>) |<br>
 */
public interface Colors {

	/**
	 * The black RGB color constant.<br>
	 * <br>
	 * The value <code>0x000000</code> is assigned to <code>BLACK</code>.
	 */
	public static final int BLACK = 0x000000;

	/**
	 * The blue RGB color constant.<br>
	 * <br>
	 * The value <code>0x0000ff</code> is assigned to <code>BLUE</code>.
	 */
	public static final int BLUE = 0x0000ff;

	/**
	 * The cyan RGB color constant.<br>
	 * <br>
	 * The value <code>0x00ffff</code> is assigned to <code>CYAN</code>.
	 */
	public static final int CYAN = 0x00ffff;

	/**
	 * The gray RGB color constant.<br>
	 * <br>
	 * The value <code>0x808080</code> is assigned to <code>GRAY</code>.
	 */
	public static final int GRAY = 0x808080;

	/**
	 * The green RGB color constant.<br>
	 * <br>
	 * The value <code>0x008000</code> is assigned to <code>GREEN</code>.
	 */
	public static final int GREEN = 0x008000;

	/**
	 * The lime RGB color constant.<br>
	 * <br>
	 * The value <code>0x00ff00</code> is assigned to <code>LIME</code>.
	 */
	public static final int LIME = 0x00ff00;

	/**
	 * The magenta RGB color constant.<br>
	 * <br>
	 * The value <code>0xff00ff</code> is assigned to <code>MAGENTA</code>.
	 */
	public static final int MAGENTA = 0xff00ff;

	/**
	 * The maroon RGB color constant.<br>
	 * <br>
	 * The value <code>0x800000</code> is assigned to <code>MAROON</code>.
	 */
	public static final int MAROON = 0x800000;

	/**
	 * The navy RGB color constant.<br>
	 * <br>
	 * The value <code>0x000080</code> is assigned to <code>NAVY</code>.
	 */
	public static final int NAVY = 0x000080;

	/**
	 * The olive RGB color constant.<br>
	 * <br>
	 * The value <code>0x808000</code> is assigned to <code>OLIVE</code>.
	 */
	public static final int OLIVE = 0x808000;

	/**
	 * The purple RGB color constant.<br>
	 * <br>
	 * The value <code>0x800080</code> is assigned to <code>PURPLE</code>.
	 */
	public static final int PURPLE = 0x800080;

	/**
	 * The red RGB color constant.<br>
	 * <br>
	 * The value <code>0xff0000</code> is assigned to <code>RED</code>.
	 */
	public static final int RED = 0xff0000;

	/**
	 * The silver RGB color constant.<br>
	 * <br>
	 * The value <code>0xc0c0c0</code> is assigned to <code>SILVER</code>.
	 */
	public static final int SILVER = 0xc0c0c0;

	/**
	 * The teal RGB color constant.<br>
	 * <br>
	 * The value <code>0x008080</code> is assigned to <code>TEAL</code>.
	 */
	public static final int TEAL = 0x008080;

	/**
	 * The white RGB color constant.<br>
	 * <br>
	 * The value <code>0xffffff</code> is assigned to <code>WHITE</code>.
	 */
	public static final int WHITE = 0xffffff;

	/**
	 * The yellow RGB color constant.<br>
	 * <br>
	 * The value <code>0xffff00</code> is assigned to <code>YELLOW</code>.
	 */
	public static final int YELLOW = 0xffff00;
}
