/*
 * Copyright 2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.util;

/**
 * Represents a two-dimensional object to which outlines can be added or removed.
 */
public interface Outlineable {

	/**
	 * Adds the given outline.
	 *
	 * @param left
	 *            the left side thickness of the outline.
	 * @param top
	 *            the top side thickness of the outline.
	 * @param right
	 *            the right side thickness of the outline.
	 * @param bottom
	 *            the bottom side thickness of the outline.
	 */
	void addOutline(int left, int top, int right, int bottom);

	/**
	 * Removes the given outline.
	 *
	 * @param left
	 *            the left side thickness of the outline.
	 * @param top
	 *            the top side thickness of the outline.
	 * @param right
	 *            the right side thickness of the outline.
	 * @param bottom
	 *            the bottom side thickness of the outline.
	 */
	void removeOutline(int left, int top, int right, int bottom);
}
