/*
 * Java
 *
 * Copyright 2009-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.hil;

/**
 * An interface for simulator stop listeners. When the simulator is stopping its
 * execution it calls the {@link #stop(boolean)} method.
 * <p>
 * Use the {@link NativeInterface#addStopListener(StopListener)} method to
 * register a new {@link StopListener}.
 */
public interface StopListener {

	/**
	 * Called when the simulator has stopped.
	 * 
	 * @param isEvalVersion
	 *            if true, the simulator has stopped because of the evaluation
	 *            limitations
	 */
	public void stop(boolean isEvalVersion);
}
