/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright (C) 2015-2020 MicroEJ Corp. EDC compliance and optimizations.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.security.cert;

/**
 * Interface for an X.509 extension.
 *
 * <p>
 * The extensions defined for X.509 v3 {@link X509Certificate Certificates} provide methods for associating additional
 * attributes with users or public keys, for managing the certification hierarchy, and for managing CRL distribution.
 * The X.509 extensions format also allows communities to define private extensions to carry information unique to those
 * communities.
 *
 * <p>
 * Each extension in a certificate/CRL may be designated as critical or non-critical. A certificate/CRL-using system (an
 * application validating a certificate/CRL) must reject the certificate/CRL if it encounters a critical extension it
 * does not recognize. A non-critical extension may be ignored if it is not recognized.
 * <p>
 * The ASN.1 definition for this is:
 *
 * <pre>
 * Extensions  ::=  SEQUENCE SIZE (1..MAX) OF Extension
 *
 * Extension  ::=  SEQUENCE  {
 *     extnId        OBJECT IDENTIFIER,
 *     critical      BOOLEAN DEFAULT FALSE,
 *     extnValue     OCTET STRING
 *                   -- contains a DER encoding of a value
 *                   -- of the type registered for use with
 *                   -- the extnId object identifier value
 * }
 * </pre>
 *
 * Since not all extensions are known, the {@code getExtensionValue} method returns the DER-encoded OCTET STRING of the
 * extension value (i.e., the {@code extnValue}). This can then be handled by a <em>Class</em> that understands the
 * extension.
 *
 * @author Hemma Prafullchandra
 */

public interface X509Extension {

}
