/*
 * Java
 *
 * Copyright 2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth.util;

/**
 * The <code>AdvertisementFlags</code> class enumerates the values for advertising data flags.
 * <p>
 * Multiple flags may be combined to create a set of advertising data flags.
 * <p>
 * Refer to «Core Specification Supplement Part A, 1.3 Flags».
 */
public class AdvertisementFlags {

	/** Limited Discoverable Mode. */
	public static final byte LE_LIMITED_DISC_MODE = 0x01;

	/** General Discoverable Mode. */
	public static final byte LE_GENERAL_DISC_MODE = 0x02;

	/** BR/EDR Not Supported. */
	public static final byte BR_EDR_NOT_SUPPORTED = 0x04;

	/** Simultaneous LE and BR/EDR to Same Device Capable (Controller). */
	public static final byte LE_BR_EDR_CONTROLLER = 0x08;

	/** Simultaneous LE and BR/EDR to Same Device Capable (Host). */
	public static final byte LE_BR_EDR_HOST = 0x10;

	private AdvertisementFlags() {
		// private constructor
	}
}
