/*
 * Copyright (c) 1999, 2012, Oracle and/or its affiliates. All rights reserved.
 * Copyright (C) 2015-2022 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. The Copyright holder(s) designates
 * this particular file as subject to the "Classpath" exception as provided
 * by the Copyright holder(s) in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact the Copyright holder(s) if you need additional information
 * or have any questions.
 * (if Oracle: 500 Oracle Parkway, Redwood Shores, CA 94065 USA or visit www.oracle.com)
 */

package javax.net.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;

import ej.annotation.Nullable;

/**
 * This class acts as a factory for trust managers based on a source of trust material. Each trust manager manages a
 * specific type of trust material for use by secure sockets. The trust material is based on a KeyStore and/or provider
 * specific sources.
 *
 * @since 1.4
 * @see TrustManager
 */
public class TrustManagerFactory {

	/**
	 * Obtains the default TrustManagerFactory algorithm name.
	 *
	 * <p>
	 * The default TrustManager can be changed at runtime by setting the value of the
	 * {@code ssl.TrustManagerFactory.algorithm} security property to the desired algorithm name.
	 *
	 * @return the default algorithm name as specified by the {@code ssl.TrustManagerFactory.algorithm} security
	 *         property, or an implementation-specific default if no such property exists.
	 */
	public final static String getDefaultAlgorithm() {
		throw new RuntimeException();
	}

	/**
	 * Returns the algorithm name of this <code>TrustManagerFactory</code> object.
	 *
	 * <p>
	 * This is the same name that was specified in one of the <code>getInstance</code> calls that created this
	 * <code>TrustManagerFactory</code> object.
	 *
	 * @return the algorithm name of this <code>TrustManagerFactory</code> object
	 */
	public final String getAlgorithm() {
		throw new RuntimeException();
	}

	/**
	 * Returns a <code>TrustManagerFactory</code> object that acts as a factory for trust managers.
	 *
	 * <p>
	 * This method traverses the list of registered security Providers, starting with the most preferred Provider. A new
	 * TrustManagerFactory object encapsulating the TrustManagerFactorySpi implementation from the first Provider that
	 * supports the specified algorithm is returned.
	 *
	 *
	 * @param algorithm
	 *            the standard name of the requested trust management algorithm. See the
	 *            <a href= "{@docRoot}/../technotes/guides/security/jsse/JSSERefGuide.html"> Java Secure Socket
	 *            Extension Reference Guide </a> for information about standard algorithm names.
	 *
	 * @return the new <code>TrustManagerFactory</code> object.
	 *
	 * @exception NoSuchAlgorithmException
	 *                if no Provider supports a TrustManagerFactorySpi implementation for the specified algorithm.
	 * @exception NullPointerException
	 *                if algorithm is null.
	 *
	 */
	public static final TrustManagerFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
		throw new RuntimeException();
	}

	/**
	 * Initializes this factory with a source of certificate authorities and related trust material.
	 * <P>
	 * The provider typically uses a KeyStore as a basis for making trust decisions.
	 * <P>
	 *
	 * @param ks
	 *            the key store, or null
	 * @throws KeyStoreException
	 *             if this operation fails
	 */
	public final void init(@Nullable KeyStore ks) throws KeyStoreException {
		throw new RuntimeException();
	}

	/**
	 * Returns one trust manager for each type of trust material.
	 *
	 * @throws IllegalStateException
	 *             if the factory is not initialized.
	 *
	 * @return the trust managers
	 */
	public final TrustManager[] getTrustManagers() {
		throw new RuntimeException();
	}
}
