/*
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.style;

import ej.microui.display.Colors;
import ej.mwt.style.background.Background;
import ej.mwt.style.background.RectangularBackground;
import ej.mwt.style.dimension.Dimension;
import ej.mwt.style.dimension.NoDimension;
import ej.mwt.style.outline.NoOutline;
import ej.mwt.style.outline.Outline;
import ej.mwt.util.Alignment;

/**
 * Defines the value of each field of the default style.
 * <p>
 * The default style has:
 * <ul>
 * <li>no dimension,</li>
 * <li>left horizontal alignment,</li>
 * <li>top vertical alignment,</li>
 * <li>no margin,</li>
 * <li>no border,</li>
 * <li>no padding,</li>
 * <li>white rectangular background,</li>
 * <li>black color,</li>
 * <li>default font,</li>
 * <li>no extra field.</li>
 * </ul>
 */
public class DefaultStyle {

	/**
	 * The dimension of the default style.
	 */
	public static final Dimension DIMENSION = NoDimension.NO_DIMENSION;

	/**
	 * The horizontal alignment of the default style.
	 */
	public static final int HORIZONTAL_ALIGNMENT = Alignment.LEFT;

	/**
	 * The vertical alignment of the default style.
	 */
	public static final int VERTICAL_ALIGNMENT = Alignment.TOP;

	/**
	 * The margin of the default style.
	 */
	public static final Outline MARGIN = NoOutline.NO_OUTLINE;

	/**
	 * The border of the default style.
	 */
	public static final Outline BORDER = NoOutline.NO_OUTLINE;

	/**
	 * The padding of the default style.
	 */
	public static final Outline PADDING = NoOutline.NO_OUTLINE;

	/**
	 * The background of the default style.
	 */
	public static final Background BACKGROUND = new RectangularBackground(Colors.WHITE);

	/**
	 * The color of the default style.
	 */
	public static final int COLOR = Colors.BLACK;

	private DefaultStyle() {
	}
}
