/*
 * Java
 *
 * 2020-2022 ESR - Not subject to Copyright.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.display;

/**
 * The <code>Painter</code> class provides static methods to draw basic shapes such as lines, rectangles, circles,
 * characters and images.
 * <p>
 * Every method uses the color, the translation and the clip which are set in the given {@link GraphicsContext}. The
 * background color and the ellipsis width are only used by a few methods.
 */
public class Painter {

	private Painter() {
		// static methods only
	}

	/**
	 * Draws the pixel at the given coordinates.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the pixel.
	 * @param y
	 *            the y coordinate of the pixel.
	 */
	public static void writePixel(GraphicsContext gc, int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Draws an horizontal line between two points.
	 * <p>
	 * The line is drawn from the point with the <code>(x,y)</code> coordinates to the point with the
	 * <code>(x+length-1,y)</code> coordinates. The drawn line is composed of <code>length</code> pixels. If
	 * <code>length</code> is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the first point of the line.
	 * @param y
	 *            the y coordinate of the two points line.
	 * @param length
	 *            the length of the line.
	 */
	public static void drawHorizontalLine(GraphicsContext gc, int x, int y, int length) {
		throw new RuntimeException();
	}

	/**
	 * Draws a vertical line between two points.
	 * <p>
	 * The line is drawn from the point with the <code>(x,y)</code> coordinates to the point with the
	 * <code>(x,y+length-1)</code> coordinates. The drawn line is composed of <code>length</code> pixels. If
	 * <code>length</code> is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the first point of the line.
	 * @param y
	 *            the y coordinate of the two points of the line.
	 * @param length
	 *            the length of the line.
	 */
	public static void drawVerticalLine(GraphicsContext gc, int x, int y, int length) {
		throw new RuntimeException();
	}

	/**
	 * Draws a line between two points.
	 * <p>
	 * The line is drawn from the point with the <code>(startX,startY)</code> coordinates to the point with the
	 * <code>(endX,endY)</code> coordinates.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param startX
	 *            the x coordinate of the first point of the line.
	 * @param startY
	 *            the y coordinate of the first point of the line.
	 * @param endX
	 *            the x coordinate of the second point of the line.
	 * @param endY
	 *            the y coordinate of the second point of the line.
	 */
	public static void drawLine(GraphicsContext gc, int startX, int startY, int endX, int endY) {
		throw new RuntimeException();
	}

	/**
	 * Draws an orthogonal rectangle.
	 * <p>
	 * The four points of the rectangle have the following coordinates: <code>(x,y)</code>, <code>(x+width-1,y)</code>,
	 * <code>(x,y+height-1)</code> and <code>(x+width-1,y+height-1)</code>.
	 * <p>
	 * If either <code>width</code> or <code>height</code> is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the rectangle.
	 * @param y
	 *            the y coordinate of the rectangle.
	 * @param width
	 *            the width of the rectangle.
	 * @param height
	 *            the height of the rectangle.
	 */
	public static void drawRectangle(GraphicsContext gc, int x, int y, int width, int height) {
		throw new RuntimeException();
	}

	/**
	 * Fills an orthogonal rectangle.
	 * <p>
	 * The four points of the rectangle have the following coordinates: <code>(x,y)</code>, <code>x+width-1,y</code>,
	 * <code>(x,y+height-1)</code> and <code>(x+width-1,y+height-1)</code>.
	 * <p>
	 * If either <code>width</code> or <code>height</code> is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the rectangle.
	 * @param y
	 *            the y coordinate of the rectangle.
	 * @param width
	 *            the width of the rectangle.
	 * @param height
	 *            the height of the rectangle.
	 */
	public static void fillRectangle(GraphicsContext gc, int x, int y, int width, int height) {
		throw new RuntimeException();
	}

	/**
	 * Draws an orthogonal rectangle with rounded corners.
	 * <p>
	 * The four points of the rectangle have the following coordinates: <code>(x,y)</code>, <code>x+width-1,y</code>,
	 * <code>(x,y+height-1)</code> and <code>(x+width-1,y+height-1)</code>.
	 * <p>
	 * If either <code>width</code> or <code>height</code> is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the rectangle.
	 * @param y
	 *            the y coordinate of the rectangle.
	 * @param width
	 *            the width of the rectangle.
	 * @param height
	 *            the height of the rectangle.
	 * @param cornerEllipseWidth
	 *            the horizontal diameter of the corner arcs.
	 * @param cornerEllipseHeight
	 *            the vertical diameter of the corner arcs.
	 */
	public static void drawRoundedRectangle(GraphicsContext gc, int x, int y, int width, int height,
			int cornerEllipseWidth, int cornerEllipseHeight) {
		throw new RuntimeException();
	}

	/**
	 * Fills an orthogonal rectangle with rounded corners.
	 * <p>
	 * The four points of the rectangle have the following coordinates: <code>(x,y)</code>, <code>x+width-1,y</code>,
	 * <code>(x,y+height-1)</code> and <code>(x+width-1,y+height-1)</code>.
	 * <p>
	 * If either <code>width</code> or <code>height</code> is negative or zero, nothing is drawn. If either
	 * <code>cornerEllipseWidth</code> or <code>arcHeight</code> is negative or zero, a regular rectangle is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the rectangle.
	 * @param y
	 *            the y coordinate of the rectangle.
	 * @param width
	 *            the width of the rectangle.
	 * @param height
	 *            the height of the rectangle.
	 * @param cornerEllipseWidth
	 *            the horizontal diameter of the corner arcs.
	 * @param cornerEllipseHeight
	 *            the vertical diameter of the corner arcs.
	 */
	public static void fillRoundedRectangle(GraphicsContext gc, int x, int y, int width, int height,
			int cornerEllipseWidth, int cornerEllipseHeight) {
		throw new RuntimeException();
	}

	/**
	 * Draws a circle arc.
	 * <p>
	 * The center of the circle is defined as the center of the square whose origin is at <code>(x,y)</code> (upper-left
	 * corner) and whose dimension is <code>(diameter,diameter)</code>.
	 * <p>
	 * The circle arc is drawn from <code>startAngle</code> to <code>startAngle+arcAngle</code> degrees. The value of
	 * <code>startAngle</code> is interpreted such that 0 degrees is along the positive x axis.
	 * <p>
	 * A positive angle indicates a counter-clockwise rotation while a negative angle indicates a clockwise rotation.
	 * <p>
	 * If the <code>diameter</code> is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the bounding rectangle of the circle.
	 * @param y
	 *            the y coordinate of the bounding rectangle of the circle.
	 * @param diameter
	 *            the diameter of the circle.
	 * @param startAngle
	 *            the start angle of the arc.
	 * @param arcAngle
	 *            the angular distance of the arc.
	 */
	public static void drawCircleArc(GraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle) {
		throw new RuntimeException();
	}

	/**
	 * Draws an ellipse arc. Ellipses which focal points are not on the same axis are not supported.
	 *
	 * The center of the ellipse is defined as the center of the rectangle whose origin is at <code>(x,y)</code>
	 * (upper-left corner) and whose dimension is <code>(width,height)</code>.
	 * <p>
	 * The ellipse arc is drawn from <code>startAngle</code> to <code>startAngle+arcAngle</code> degrees. The value of
	 * <code>startAngle</code> is interpreted such that 0 degrees is along the positive x axis.
	 * <p>
	 * A positive angle indicates a counter-clockwise rotation while a negative angle indicates a clockwise rotation.
	 * <p>
	 * The angles are given relative to the rectangle. For instance an angle of 45 degrees is always defined by the line
	 * from the center of the rectangle to the upper right corner of the rectangle. Thus for a non squared rectangle
	 * angles are skewed along either height or width.
	 * <p>
	 * If either <code>width</code> or <code>height</code> is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the bounding rectangle of the ellipse.
	 * @param y
	 *            the y coordinate of the bounding rectangle of the ellipse.
	 * @param width
	 *            the width of the ellipse.
	 * @param height
	 *            the height of the ellipse.
	 * @param startAngle
	 *            the start angle of the arc.
	 * @param arcAngle
	 *            the angular distance of the arc.
	 */
	public static void drawEllipseArc(GraphicsContext gc, int x, int y, int width, int height, float startAngle,
			float arcAngle) {
		throw new RuntimeException();
	}

	/**
	 * Fills a circle arc.
	 * <p>
	 * The center of the circle is defined as the center of the square whose origin is at <code>(x,y)</code> (upper-left
	 * corner) and whose dimension is <code>(diameter,diameter)</code>.
	 * <p>
	 * The circle arc is drawn from <code>startAngle</code> to <code>startAngle+arcAngle</code> degrees. The value of
	 * <code>startAngle</code> is interpreted such that 0 degrees is along the positive x axis.
	 * <p>
	 * A positive angle indicates a counter-clockwise rotation while a negative angle indicates a clockwise rotation.
	 * <p>
	 * If the given diameter is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the bounding rectangle of the circle.
	 * @param y
	 *            the y coordinate of the bounding rectangle of the circle.
	 * @param diameter
	 *            the diameter of the circle.
	 * @param startAngle
	 *            the start angle of the arc.
	 * @param arcAngle
	 *            the angular distance of the arc.
	 */
	public static void fillCircleArc(GraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle) {
		throw new RuntimeException();
	}

	/**
	 * Fills an ellipse arc. Ellipses which focal points are not on the same axis are not supported.
	 *
	 * The center of the ellipse is defined as the center of the rectangle whose origin is at <code>(x,y)</code>
	 * (upper-left corner) and whose dimension is <code>(width,height)</code>.
	 * <p>
	 * The ellipse arc is drawn from <code>startAngle</code> to <code>startAngle+arcAngle</code> degrees. The value of
	 * <code>startAngle</code> is interpreted such that 0 degrees is along the positive x axis.
	 * <p>
	 * A positive angle indicates a counter-clockwise rotation while a negative angle indicates a clockwise rotation.
	 * <p>
	 * The angles are given relative to the rectangle. For instance an angle of 45 degrees is always defined by the line
	 * from the center of the rectangle to the upper right corner of the rectangle. Thus for a non squared rectangle
	 * angles are skewed along either height or width.
	 * <p>
	 * If either <code>width</code> or <code>height</code> is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the bounding rectangle of the ellipse.
	 * @param y
	 *            the y coordinate of the bounding rectangle of the ellipse.
	 * @param width
	 *            the width of the ellipse.
	 * @param height
	 *            the height of the ellipse.
	 * @param startAngle
	 *            the start angle of the arc.
	 * @param arcAngle
	 *            the angular distance of the arc.
	 */
	public static void fillEllipseArc(GraphicsContext gc, int x, int y, int width, int height, float startAngle,
			float arcAngle) {
		throw new RuntimeException();
	}

	/**
	 * Draws a circle.
	 * <p>
	 * The center of the circle is defined as the center of the square whose origin is at <code>(x,y)</code> (upper-left
	 * corner) and whose dimension is <code>(diameter,diameter)</code>.
	 * <p>
	 * If the given diameter is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the bounding rectangle of the circle.
	 * @param y
	 *            the y coordinate of the bounding rectangle of the circle.
	 * @param diameter
	 *            the diameter of the circle.
	 */
	public static void drawCircle(GraphicsContext gc, int x, int y, int diameter) {
		throw new RuntimeException();
	}

	/**
	 * Fills a circle.
	 * <p>
	 * The center of the circle is defined as the center of the square whose origin is at <code>(x,y)</code> (upper-left
	 * corner) and whose dimension is <code>(diameter,diameter)</code>.
	 * <p>
	 * If the given diameter is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the bounding rectangle of the circle.
	 * @param y
	 *            the y coordinate of the bounding rectangle of the circle.
	 * @param diameter
	 *            the diameter of the circle.
	 */
	public static void fillCircle(GraphicsContext gc, int x, int y, int diameter) {
		throw new RuntimeException();
	}

	/**
	 * Draws an ellipse. Ellipses which focal points are not on the same axis are not supported.
	 *
	 * The center of the ellipse is defined as the center of the rectangle whose origin is at <code>(x,y)</code>
	 * (upper-left corner) and whose dimension is <code>(width,height)</code>.
	 * <p>
	 * If either <code>width</code> or <code>height</code> is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the bounding rectangle of the ellipse.
	 * @param y
	 *            the y coordinate of the bounding rectangle of the ellipse.
	 * @param width
	 *            the width of the ellipse.
	 * @param height
	 *            the height of the ellipse.
	 */
	public static void drawEllipse(GraphicsContext gc, int x, int y, int width, int height) {
		throw new RuntimeException();
	}

	/**
	 * Fills an ellipse. Ellipses which focal points are not on the same axis are not supported.
	 *
	 * The center of the ellipse is defined as the center of the rectangle whose origin is at <code>(x,y)</code>
	 * (upper-left corner) and whose dimension is <code>(width,height)</code>.
	 * <p>
	 * If either <code>width</code> or <code>height</code> is negative or zero, nothing is drawn.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param x
	 *            the x coordinate of the bounding rectangle of the ellipse.
	 * @param y
	 *            the y coordinate of the bounding rectangle of the ellipse.
	 * @param width
	 *            the width of the ellipse.
	 * @param height
	 *            the height of the ellipse.
	 */
	public static void fillEllipse(GraphicsContext gc, int x, int y, int width, int height) {
		throw new RuntimeException();
	}

	/**
	 * Draws a region of the display.
	 * <p>
	 * Equivalent to calling {@link #drawDisplayRegion(GraphicsContext, int, int, int, int, int, int, int)} with
	 * {@link GraphicsContext#OPAQUE} as alpha.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param xSource
	 *            the x coordinate of the region to copy.
	 * @param ySource
	 *            the y coordinate of the region to copy.
	 * @param width
	 *            the width of the region to copy.
	 * @param height
	 *            the height of the region to copy.
	 * @param xDestination
	 *            the x coordinate to draw at.
	 * @param yDestination
	 *            the y coordinate to draw at.
	 */
	public static void drawDisplayRegion(GraphicsContext gc, int xSource, int ySource, int width, int height,
			int xDestination, int yDestination) {
		throw new RuntimeException();
	}

	/**
	 * Draws a region of the display. This methods supports transparent drawings.
	 * <p>
	 * The four points of the source rectangle have the following coordinates: <code>(xSource,ySource)</code>,
	 * <code>(xSource+width-1,ySource)</code>, <code>(xSource,ySource+height-1)</code> and
	 * <code>(xSource+width-1,ySource+height-1)</code>. However, this rectangle is limited to the boundaries of the
	 * display.
	 * <p>
	 * In addition with {@link #drawDisplayRegion(GraphicsContext, int, int, int, int, int, int)}, this method allows to
	 * specify the global opacity value to apply during the image rendering. This value is clamped between
	 * {@link GraphicsContext#TRANSPARENT} and {@link GraphicsContext#OPAQUE}.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param xSource
	 *            the x coordinate of the region to copy.
	 * @param ySource
	 *            the y coordinate of the region to copy.
	 * @param width
	 *            the width of the region to copy.
	 * @param height
	 *            the height of the region to copy.
	 * @param xDestination
	 *            the x coordinate to draw at.
	 * @param yDestination
	 *            the y coordinate to draw at.
	 * @param alpha
	 *            the alpha to apply to the region.
	 * @since 2.0
	 */
	public static void drawDisplayRegion(GraphicsContext gc, int xSource, int ySource, int width, int height,
			int xDestination, int yDestination, int alpha) {
		throw new RuntimeException();
	}

	/**
	 * Draws a string.
	 * <p>
	 * This method uses the background color and the ellipsis width which are set in the given {@link GraphicsContext}.
	 * <p>
	 * The top-left anchor point of the string is defined by the <code>(x,y)</code> coordinates. The
	 * {@link Font#getBaselinePosition() font baseline} may be used to set the anchor at the position of the string
	 * baseline.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param string
	 *            the string.
	 * @param font
	 *            the font to use.
	 * @param x
	 *            the x coordinate of the string.
	 * @param y
	 *            the y coordinate of the string.
	 */
	public static void drawString(GraphicsContext gc, String string, Font font, int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Draws a subset of a string.
	 * <p>
	 * This method uses the background color and the ellipsis width which are set in the given {@link GraphicsContext}.
	 * <p>
	 * The top-left anchor point of the string is defined by the <code>(x,y)</code> coordinates. The
	 * {@link Font#getBaselinePosition() font baseline} may be used to set the anchor at the position of the string
	 * baseline.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param string
	 *            the string.
	 * @param offset
	 *            the index of the first character of the string.
	 * @param length
	 *            the number of characters of the string.
	 * @param font
	 *            the font to use.
	 * @param x
	 *            the x coordinate of the string.
	 * @param y
	 *            the y coordinate of the string.
	 * @throws StringIndexOutOfBoundsException
	 *             if the given offset and length do not specify a valid range within the given string.
	 */
	public static void drawSubstring(GraphicsContext gc, String string, int offset, int length, Font font, int x,
			int y) {
		throw new RuntimeException();
	}

	/**
	 * Draws a character.
	 * <p>
	 * This method uses the background color and the ellipsis width which are set in the given {@link GraphicsContext}.
	 * <p>
	 * The top-left anchor point of the character is defined by the <code>(x,y)</code> coordinates. The
	 * {@link Font#getBaselinePosition() font baseline} may be used to set the anchor at the position of the character
	 * baseline.
	 * <p>
	 * This method only supports characters in the range U+0000 to U+FFFF. It does not handle characters with code
	 * points greater than U+FFFF, which are represented as a pair of char values (referred to as "surrogate pair").
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param character
	 *            the character.
	 * @param font
	 *            the font to use.
	 * @param x
	 *            the x coordinate of the string.
	 * @param y
	 *            the y coordinate of the string.
	 */
	public static void drawChar(GraphicsContext gc, char character, Font font, int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Draws the string using the font and given graphics context color. Same specification than
	 * {@link #drawString(GraphicsContext, String, Font, int, int)}
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param string
	 *            the renderable string to render.
	 * @param x
	 *            the x coordinate of the anchor point.
	 * @param y
	 *            the y coordinate of the anchor point.
	 * @see #drawString(GraphicsContext, String, Font, int, int)
	 */
	public static void drawRenderableString(GraphicsContext gc, RenderableString string, int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Draws the image at the given anchor top-left point.
	 * <p>
	 * Equivalent to calling {@link #drawImage(GraphicsContext, Image, int, int, int)} with
	 * {@link GraphicsContext#OPAQUE} as alpha.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param image
	 *            the image to render.
	 * @param x
	 *            the x coordinate of the anchor top-left point.
	 * @param y
	 *            the y coordinate of the anchor top-left point.
	 */
	public static void drawImage(GraphicsContext gc, Image image, int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Draws the image at the given anchor top-left point.
	 * <p>
	 * In addition with {@link #drawImage(GraphicsContext, Image, int, int)}, this method allows to specify the global
	 * opacity value to apply during the image rendering. This value is clamped between
	 * {@link GraphicsContext#TRANSPARENT} and {@link GraphicsContext#OPAQUE}.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param image
	 *            the image to render.
	 * @param x
	 *            the x coordinate of the anchor top-left point.
	 * @param y
	 *            the y coordinate of the anchor top-left point.
	 * @param alpha
	 *            the global opacity rendering value, between 0 (transparent) and 255 (opaque).
	 * @since 2.0
	 */
	public static void drawImage(GraphicsContext gc, Image image, int x, int y, int alpha) {
		throw new RuntimeException();
	}

	/**
	 * Draws a region of the image.
	 * <p>
	 * Equivalent to calling {@link #drawImageRegion(GraphicsContext, Image, int, int, int, int, int, int, int)} with
	 * {@link GraphicsContext#OPAQUE} as alpha.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param image
	 *            the image to render.
	 * @param xSource
	 *            the x coordinate of the upper-left corner of the region to copy.
	 * @param ySource
	 *            the y coordinate of the upper-left corner of the region to copy.
	 * @param width
	 *            the width of the region to copy.
	 * @param height
	 *            the height of the region to copy.
	 * @param xDestination
	 *            the x coordinate of the anchor top-left point in the destination.
	 * @param yDestination
	 *            the y coordinate of the anchor top-left point in the destination.
	 */
	public static void drawImageRegion(GraphicsContext gc, Image image, int xSource, int ySource, int width, int height,
			int xDestination, int yDestination) {
		throw new RuntimeException();
	}

	/**
	 * Draws a region of an image.
	 * <p>
	 * The region of the image to draw is given relative to the image (origin at the upper-left corner) as a rectangle.
	 * <p>
	 * If the specified source region exceeds the image bounds, the copied region is limited to the image boundary. If
	 * the copied region goes out of the bounds of the graphics context area, pixels out of the range will not be drawn.
	 * <p>
	 * In addition with {@link #drawImageRegion(GraphicsContext, Image, int, int, int, int, int, int)}, this method
	 * allows to specify the global opacity value to apply during the image rendering. This value is clamped between
	 * {@link GraphicsContext#TRANSPARENT} and {@link GraphicsContext#OPAQUE}.
	 *
	 * @param gc
	 *            the graphics context to use.
	 * @param image
	 *            the image to render.
	 * @param xSource
	 *            the x coordinate of the upper-left corner of the region to copy.
	 * @param ySource
	 *            the y coordinate of the upper-left corner of the region to copy.
	 * @param width
	 *            the width of the region to copy.
	 * @param height
	 *            the height of the region to copy.
	 * @param xDestination
	 *            the x coordinate of the anchor top-left point in the destination.
	 * @param yDestination
	 *            the y coordinate of the anchor top-left point in the destination.
	 * @param alpha
	 *            the alpha to apply to the region.
	 * @since 2.0
	 */
	public static void drawImageRegion(GraphicsContext gc, Image image, int xSource, int ySource, int width, int height,
			int xDestination, int yDestination, int alpha) {
		throw new RuntimeException();
	}
}
