/*
 * Java
 *
 * Copyright 2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand.connectivity;

/**
 * Class that answers queries about the connectivity of the console with a client.
 */
public interface ConnectivityManager {
	/**
	 * Returns the numbers of available connections.
	 *
	 * @return the numbers of available connections.
	 */
	int getAvailable();

	/**
	 * Returns a String representing how the service can be joined from remote
	 * clients.
	 * <p>
	 * Examples of such strings are:
	 * <ul>
	 * <li><code>192.168.0.1:4000</code> for a service listening on a TCP port
	 * on these addresses and ports.
	 * <li><code></code> for a service listening on a TCP port on these
	 * addresses and ports.
	 * <li><code>comm:com6;baudrate=115200</code> for a service listening on a
	 * COMM port with these parameters
	 * </ul>
	 *
	 * @return the connectivity URL, as a String.
	 */
	String getConnectionInfo();

	/**
	 * Adds a listener.
	 *
	 * @param listener
	 *            the listener.
	 */
	void addConnectivityListener(ConnectivityListener listener);

	/**
	 * Removes a listener.
	 *
	 * @param listener
	 *            the listener.
	 */
	void removeConnectivityListener(ConnectivityListener listener);
}
