/*
 * Java
 *
 * Copyright 2015-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt;

import com.is2t.microbsp.microui.natives.NSystemDisplay;

import ej.annotation.NonNull;
import ej.microui.display.Display;
import ej.microui.display.FlyingImage;
import ej.microui.display.GraphicsContext;

/**
 * Utility class to repaint a renderable.
 */
/* package */abstract class RepaintRenderable implements Runnable {
	private static int PendingRepaint;
	@NonNull
	/* package */final Desktop desktop;
	/* package */final int x;
	/* package */final int y;
	/* package */final int width;
	/* package */final int height;

	/* package */ RepaintRenderable(@NonNull Desktop desktop, int x, int y, int width, int height) {
		PendingRepaint++;
		this.desktop = desktop;
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
	}

	@Override
	public void run() {
		// check if the view has to be repaint (there is a delay between
		// the event sending and its treatment)
		if (this.desktop != null && this.desktop.isShown()) {
			Display display = this.desktop.getDisplay();
			GraphicsContext g = display.graphics;
			int sd = g.sd;
			try {
				// remove flyingImages
				NSystemDisplay.changeBackground(sd, FlyingImage.OFF);

				paint(g);
			} finally {
				// redraw all flyingImages
				NSystemDisplay.changeBackground(sd, FlyingImage.ON);

				// flush screen
				if (--PendingRepaint == 0) {
					display.executeEventFlush();
				} else {
					display.addPendingFlush();
				}
			}
		}
	}

	protected abstract void paint(@NonNull GraphicsContext g);
}
