/*
 * Java
 *
 * Copyright 2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.hal;

/**
 * This class provides a way to handle watchdog timers. It is implemented over a
 * low level watchdog timer and provides a checkpoint registration system. The
 * registration system allows to add checkpoints monitored by the watchdog.
 */
public class WatchdogTimer {

	/**
	 * Watchdog private constructor
	 */
	private WatchdogTimer() {
		// Prevent the instantiation of this class
	}

	/**
	 * Initializes the watchdog timer and the checkpoints registration system.
	 *
	 * This method does nothing if the watchdog is already initialized.
	 *
	 * @throws WatchdogTimerException if an error occurs.
	 *
	 */
	public static void init() throws WatchdogTimerException {
		throw new RuntimeException();
	}

	/**
	 * Starts the watchdog timer.
	 *
	 * This method does nothing if the watchdog is already started.
	 *
	 * @throws WatchdogTimerException if the watchdog is not initialized or an error
	 *                           occurs.
	 *
	 */
	public static void start() throws WatchdogTimerException {
		throw new RuntimeException();
	}

	/**
	 * Stops the watchdog timer and unregisters all existing checkpoints.
	 *
	 * This method does nothing if the watchdog is not started.
	 *
	 * @throws WatchdogTimerException if an error occurs.
	 */
	public static void stop() throws WatchdogTimerException {
		throw new RuntimeException();
	}

	/**
	 * Registers a watchdog checkpoint and returns its corresponding Id.
	 *
	 * The maximum number of checkpoints that can be registered is 32 and the
	 * checkpoint Id values are comprise between 0 and 31.
	 *
	 * @return the registered checkpoint Id.
	 *
	 * @throws WatchdogTimerException if we exceed the maximum number of registrations or
	 *                           if watchdog was not initialized.
	 */
	public static int registerCheckpoint() throws WatchdogTimerException {
		throw new RuntimeException();
	}

	/**
	 * Unregisters the checkpoint with the given {@code checkpointId}.
	 *
	 * @param checkpointId the checkpoint Id to unregister.
	 *
	 * @throws WatchdogTimerException        if watchdog is not initialized or the
	 *                                  checkpointId is not registered.
	 *
	 * @throws IllegalArgumentException if checkpointId is out of the range.
	 */
	public static void unregisterCheckpoint(int checkpointId) throws WatchdogTimerException, IllegalArgumentException {
		throw new RuntimeException();
	}

	/**
	 * Validates the checkpoint identified by the given {@code checkpointId} and
	 * refreshes the watchdog if all checkpoints are passed.
	 *
	 * Be sure that all the checkpoints are validated before the watchdog timeout
	 * expires otherwise a hardware reset will be performed.
	 *
	 * @param checkpointId the Id of the checkpoint to validate.
	 *
	 * @throws WatchdogTimerException        if the watchdog is not initialized<br>
	 *                                  if the checkpointId is not registered or an
	 *                                  error occurs.
	 *
	 * @throws IllegalArgumentException if checkpointId is out of the range.
	 */
	public static void checkpoint(int checkpointId) throws WatchdogTimerException, IllegalArgumentException {
		throw new RuntimeException();
	}

	/**
	 * Checks whether the last reset was caused by the watchdog or not.
	 *
	 * @return true if the last reset was caused by the watchdog; false otherwise.
	 *
	 * @throws WatchdogTimerException if an error occurs.
	 */
	public static boolean isResetCause() throws WatchdogTimerException {
		throw new RuntimeException();
	}

	/**
	 * Gets the configured watchdog timeout period (in milliseconds).
	 *
	 * @return the watchdog timeout period.
	 *
	 * @throws WatchdogTimerException if an error occurs.
	 */
	public static int getWatchdogTimeoutMs() throws WatchdogTimerException {
		throw new RuntimeException();
	}
}
