/*
 * Java
 *
 * Copyright 2014-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.websocket;

/**
 * A special kind of exception thrown by classes associated to {@link WebSocket}s.
 *
 *
 *
 */
public class WebSocketException extends Exception {

	/**
	 * Serial Version UID.
	 */
	private static final long serialVersionUID = 4400806274202577310L;

	/**
	 * Create a new Websocket exception.
	 *
	 * @param string
	 *            message to describe the error case
	 */
	public WebSocketException(String string) {
		super(string);
	}

	/**
	 * Create a new Websocket exception.
	 *
	 * @param string
	 *            message to describe the error case
	 * @param e
	 *            the original exception
	 */
	public WebSocketException(String string, Exception e) {
		super(string, e);
	}

	/**
	 * Create a new Websocket exception.
	 *
	 * @param e
	 *            the original exception
	 */
	public WebSocketException(Exception e) {
		super(e);
	}

	/**
	 *
	 */
	public WebSocketException() {
	}

}
