/*
 * Copyright 2022-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.widget.debug;

import ej.mwt.Container;
import ej.mwt.Widget;

/**
 * Visitor for {@link Widget} and {@link Container}.
 */
public interface WidgetVisitor {

	/**
	 * Signals the children of a {@link Container} are about to be visited.
	 */
	void beginContainer();

	/**
	 * Visits a {@link Widget}.
	 *
	 * @param widget
	 *            the visited widget.
	 */
	void visitWidget(Widget widget);

	/**
	 * Signals the children of a {@link Container} just have all been visited.
	 */
	void endContainer();

}
