/*
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.motion.util;

public interface MotionListener {

	/**
	 * The motion is started.
	 *
	 * @param value
	 *            the start value of the motion.
	 */
	void start(int value);

	/**
	 * A new step in the motion.
	 *
	 * @param value
	 *            the current value of the motion.
	 */
	void step(int value);

	/**
	 * The motion is finished.
	 *
	 * @param value
	 *            the stop value of the motion.
	 */
	void stop(int value);

	/**
	 * The motion is cancelled.
	 */
	void cancel();

}
