/*
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.motion.linear;

import ej.motion.Motion;
import ej.motion.MotionManager;
import ej.motion.util.TossHelper;

/**
 * Motion manager creating linear motions.
 */
public class LinearMotionManager implements MotionManager {

	@Override
	public Motion easeIn(int start, int stop, long duration) {
		return move(start, stop, duration);
	}

	@Override
	public Motion easeOut(int start, int stop, long duration) {
		return move(start, stop, duration);
	}

	@Override
	public Motion easeInOut(int start, int stop, long duration) {
		return move(start, stop, duration);
	}

	private Motion move(int start, int stop, long maxDuration) {
		try {
			return new LinearMotion(start, stop, maxDuration);
		} catch (ArithmeticException e) {
			// if duration is 0
			return new LinearMotion(start, stop, 1);
		}
	}

	@Override
	public Motion toss(int start, int min, int max, float initialSpeed, long duration) {
		int stop = TossHelper.computeExpectedStop(start, initialSpeed, duration);
		return new LinearMotion(start, stop, duration);
	}

}
