/*
 * Java
 *
 * Copyright 2021-2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.microvg.test;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import ej.microui.display.Colors;
import ej.microui.display.Display;
import ej.microui.display.GraphicsContext;
import ej.microvg.BlendMode;
import ej.microvg.Matrix;
import ej.microvg.Path;
import ej.microvg.VectorGraphicsPainter;
import ej.microvg.VectorGraphicsPainter.FillType;

/**
 * Tests the drawing of colored path with alpha level.
 */
@SuppressWarnings("nls")
public class TestAlpha {

	/**
	 * Starts MicroUI.
	 */
	@BeforeClass
	public static void pre() {
		TestUtilities.startMicroUI();
	}

	/**
	 * Stops MicroUI.
	 */
	@AfterClass
	public static void post() {
		TestUtilities.stopMicroUI();
	}

	/**
	 * Resets the content of the screen to black.
	 */
	@Before
	public static void preTest() {
		TestUtilities.clearScreen();
	}

	/**
	 * Tests a square path drawn with a partially transparent alpha.
	 */
	@Test
	public static void testPathSquareSemiTransparent() {
		Display display = Display.getDisplay();
		GraphicsContext g = display.getGraphicsContext();

		Path path = new Path();
		path.moveTo(0, 0);
		path.lineTo(100, 0);
		path.lineTo(100, 100);
		path.lineTo(0, 100);
		path.close();

		g.setColor(Colors.RED);
		VectorGraphicsPainter.fillPath(g, path, new Matrix(), FillType.WINDING, 0x88, BlendMode.SRC_OVER);
		display.flush();

		TestUtilities.check("top left", 0, 0, g, 0x880000);
		TestUtilities.check("center", 49, 49, g, 0x880000);
		TestUtilities.check("bottom right", 99, 99, g, 0x880000);
	}

	/**
	 * Tests a square path drawn with a fully transparent alpha.
	 */
	@Test
	public static void testPathSquareTransparent() {
		Display display = Display.getDisplay();
		GraphicsContext g = display.getGraphicsContext();

		Path path = new Path();
		path.moveTo(0, 0);
		path.lineTo(100, 0);
		path.lineTo(100, 100);
		path.lineTo(0, 100);
		path.close();

		g.setColor(Colors.RED);
		VectorGraphicsPainter.fillPath(g, path, new Matrix(), FillType.WINDING, 0x0, BlendMode.SRC_OVER);
		display.flush();

		TestUtilities.check("top left", 0, 0, g, TestUtilities.BACKGROUND_COLOR);
		TestUtilities.check("center", 49, 49, g, TestUtilities.BACKGROUND_COLOR);
		TestUtilities.check("bottom right", 99, 99, g, TestUtilities.BACKGROUND_COLOR);
	}

}
