/*
 * Java
 *
 * Copyright 2011-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.sp;

/**
 * The <code>SPReader</code> interface provides a method for reconstructing objects from a block.
 */
public interface SPReader {

	/**
	 * Reads and returns an object from a block of the given {@link ShieldedPlug}. The class implementing this interface
	 * defines how the object is "read".
	 *
	 * @param sp
	 *            the {@link ShieldedPlug} from which data is read
	 * @param blockID
	 *            the ID of the block
	 * @return the object read from the {@link ShieldedPlug}
	 * @throws IllegalArgumentException
	 *             if no block is defined with the given ID
	 * @throws IndexOutOfBoundsException
	 *             if the block length is lower than the size needed for object de-serialization
	 * @throws EmptyBlockException
	 *             if no data is available in the block
	 */
	public Object readObject(ShieldedPlug sp, int blockID) throws EmptyBlockException;

}
