/*
 * Java
 *
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util.module;

import ej.annotation.Nullable;

/**
 * Sandboxed module helper.
 */
public interface SandboxedModuleHelper {

	/**
	 * Returns the {@link SandboxedModule} associated with the current thread context.
	 *
	 * @return the current {@link SandboxedModule} owning the current execution context.
	 */
	SandboxedModule getCurrentModule();

	/**
	 * Returns the {@link SandboxedModule} that owns the given module name.
	 *
	 * @param moduleName
	 * 		the name of the module to look up.
	 * @return the corresponding {@link SandboxedModule}, or {@code null} if none found.
	 */
	@Nullable
	SandboxedModule getModule(String moduleName);

} 
