/*
 * Decompiled with CFR 0.152.
 */
package ej.property.loader;

import ej.annotation.Nullable;
import ej.property.PropertyLoader;
import ej.property.PropertyPermission;

public class SystemPropertyLoader
implements PropertyLoader {
    @Override
    @Nullable
    public String getProperty(String key) {
        this.checkSecurity(key);
        return System.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        this.checkSecurity(key);
        return System.getProperty(key, defaultValue);
    }

    private void checkSecurity(String key) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String className = this.getClass().getSimpleName();
            securityManager.checkPermission(new PropertyPermission(className, key, "get"));
        }
    }
}

