/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket.util;

public class UTF8Validator {
    private UTF8Validator() {
    }

    public static boolean isValid(byte[] bytes, int offset, int length) {
        int totalLength = offset + length;
        if (totalLength > bytes.length || offset < 0 || length < 0) {
            return false;
        }
        int numberOfBytesToProcess = 0;
        int firstByte = 0;
        int i = offset;
        while (i < totalLength) {
            int b = bytes[i] & 0xFF;
            if (numberOfBytesToProcess <= 0) {
                if ((b & 0xF0) == 240) {
                    if (b > 244) {
                        return false;
                    }
                    numberOfBytesToProcess = 4;
                } else if ((b & 0xE0) == 224) {
                    numberOfBytesToProcess = 3;
                } else if ((b & 0xC0) == 192) {
                    if (b < 194) {
                        return false;
                    }
                    numberOfBytesToProcess = 2;
                } else if ((b & 0x80) == 0) {
                    numberOfBytesToProcess = 1;
                } else {
                    return false;
                }
                if (numberOfBytesToProcess > totalLength - i) {
                    return false;
                }
                firstByte = b;
            } else {
                boolean isInvalidbyte = (b & 0xC0) != 128;
                isInvalidbyte |= firstByte == 224 && numberOfBytesToProcess == 2 && (b & 0xE0) != 160;
                isInvalidbyte |= firstByte == 237 && numberOfBytesToProcess == 2 && (b & 0xE0) != 128;
                isInvalidbyte |= firstByte == 240 && numberOfBytesToProcess == 3 && (b & 0xF0) != 144 && (b & 0xE0) != 160;
                if (isInvalidbyte |= firstByte == 244 && numberOfBytesToProcess == 3 && (b & 0xF0) != 128) {
                    return false;
                }
            }
            --numberOfBytesToProcess;
            ++i;
        }
        return numberOfBytesToProcess == 0;
    }
}

