/*
 * Decompiled with CFR 0.152.
 */
package com.microej.net.test.util;

import com.microej.net.test.util.INetInit;
import ej.ecom.network.IPConfiguration;
import ej.ecom.network.NetworkInterfaceManager;
import ej.ecom.wifi.AccessPoint;
import ej.ecom.wifi.WifiManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;

public class WifiNetInit
implements INetInit {
    private static final String WIFI_PROP_PREFIX = "wifi.";
    private static final String WIFI_PROP_PASSPHRASE = "wifi.passphrase";
    private static final String WIFI_PROP_SSID = "wifi.ssid";
    private static final String WIFI_PROP_JOIN_RETRY = "wifi.join.nbretry";
    private static final int WIFI_PROP_JOIN_RETRY_VALUE_DEFAULT = 3;
    private static final Integer WIFI_PROP_JOIN_RETRY_VALUE = Integer.getInteger("wifi.join.nbretry", 3);
    private static final String NETIF_CONF_PROP_IP = "wifi.ip";
    public static final String DEFAULT_NETIF_CONF_PROP_IP_VALUE = "dhcp";
    public static final String NETIF_IPV4_NAME_PROPERTY = "netif.ipv4.name";
    public static final String NETIF_IPV6_NAME_PROPERTY = "netif.ipv6.name";
    public static final String NETIF_NAME_PROPERTY = "netif.name";
    public static final String NETIF_NAME_VALUE_DEFAULT = "wifi_interface";
    public static final String PREFER_IPV6_PROPERTY = "testsuite.preferipv6";
    private NetworkInterface netif;

    @Override
    public void initialize() throws IOException {
        String passphrase = System.getProperty(WIFI_PROP_PASSPHRASE);
        String ssid = System.getProperty(WIFI_PROP_SSID);
        if (passphrase != null && !passphrase.equals("") && ssid != null && !ssid.equals("")) {
            this.startWifiInterface();
            WifiManager wifiManager = WifiManager.getInstance();
            int nbTries = WIFI_PROP_JOIN_RETRY_VALUE;
            while (--nbTries >= 0) {
                try {
                    this.log("Trying to join access point \"" + ssid + "\"...");
                    wifiManager.join(ssid, passphrase);
                    break;
                }
                catch (IOException e) {
                    this.log("Join failed");
                    if (nbTries == 0) {
                        throw e;
                    }
                    wifiManager.leave();
                }
            }
            this.logWifiState(ssid, wifiManager);
        } else {
            this.log("Wifi settings not set (ssid=" + ssid + ", passphrase=" + passphrase + ")");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static NetworkInterface FoundInterface(String interfaceName) throws IOException {
        interfaces = NetworkInterface.getNetworkInterfaces();
        if (interfaces != null) ** GOTO lbl7
        throw new IOException("No network interfaces found");
lbl-1000:
        // 1 sources

        {
            networkInterface = interfaces.nextElement();
            if (networkInterface.getName().compareTo(interfaceName) != 0) continue;
            return networkInterface;
lbl7:
            // 2 sources

            ** while (interfaces.hasMoreElements())
        }
lbl8:
        // 1 sources

        return null;
    }

    private String getInterfaceName() {
        if (System.getProperty(NETIF_NAME_PROPERTY) != null) {
            return System.getProperty(NETIF_NAME_PROPERTY);
        }
        if (System.getProperty(PREFER_IPV6_PROPERTY).equals("true")) {
            return System.getProperty(NETIF_IPV6_NAME_PROPERTY, NETIF_NAME_VALUE_DEFAULT);
        }
        return System.getProperty(NETIF_IPV4_NAME_PROPERTY, NETIF_NAME_VALUE_DEFAULT);
    }

    private void startWifiInterface() throws SocketException, IllegalStateException, IOException {
        String interfaceName = this.getInterfaceName();
        this.netif = WifiNetInit.FoundInterface(interfaceName);
        if (this.netif == null) {
            throw new IOException("No Wifi interface \"" + interfaceName + "\" found");
        }
        if (!NetworkInterfaceManager.isStarted((NetworkInterface)this.netif)) {
            NetworkInterfaceManager.start((NetworkInterface)this.netif);
        }
        if (!NetworkInterfaceManager.isEnabled((NetworkInterface)this.netif)) {
            NetworkInterfaceManager.enable((NetworkInterface)this.netif);
        }
        IPConfiguration conf = new IPConfiguration();
        String ipConf = System.getProperty(NETIF_CONF_PROP_IP, DEFAULT_NETIF_CONF_PROP_IP_VALUE);
        if (ipConf.equals(DEFAULT_NETIF_CONF_PROP_IP_VALUE)) {
            conf.useDHCP(true);
        } else {
            conf.useDHCP(false);
            conf.setIP(InetAddress.getByName(ipConf));
        }
        try {
            NetworkInterfaceManager.configure((NetworkInterface)this.netif, (IPConfiguration)conf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void logWifiState(String ssid, WifiManager wifiManager) throws IOException {
        IPConfiguration wifiIPConf = NetworkInterfaceManager.getIPConfiguration((NetworkInterface)this.netif);
        StringBuilder sb = new StringBuilder();
        sb.append("NetIF update [ip=");
        sb.append(wifiIPConf.getIP());
        sb.append(", netmask=");
        sb.append(wifiIPConf.getNetmask());
        sb.append(", gateway=");
        sb.append(wifiIPConf.getGateway());
        InetAddress[] dnsAddrs = wifiIPConf.getDNS();
        int nbDNS = dnsAddrs.length;
        if (dnsAddrs != null && nbDNS > 0) {
            sb.append(", dns=");
            if (nbDNS == 1) {
                sb.append(dnsAddrs[0]);
            } else {
                sb.append("(");
                int i = -1;
                while (++i < nbDNS - 1) {
                    sb.append(dnsAddrs[i]);
                    sb.append(",");
                }
                sb.append(dnsAddrs[nbDNS - 1]);
                sb.append(")");
            }
        }
        sb.append("]");
        this.log(sb.toString());
        AccessPoint ap = wifiManager.getJoined();
        this.log("Wifi AP joined " + ap);
    }

    private void log(String msg) {
        System.out.println("[INFO] " + msg);
    }
}

