/*
 * Decompiled with CFR 0.152.
 */
package ej.net.util.wifi;

import ej.annotation.NonNull;
import ej.annotation.Nullable;
import ej.bon.Util;
import ej.ecom.network.IPConfiguration;
import ej.ecom.network.NetworkInterfaceManager;
import ej.ecom.wifi.AccessPoint;
import ej.ecom.wifi.SecurityMode;
import ej.ecom.wifi.SoftAPConfiguration;
import ej.ecom.wifi.WifiCapability;
import ej.ecom.wifi.WifiManager;
import ej.net.util.NetUtil;
import ej.net.util.wifi.AccessPointConfiguration;
import ej.net.util.wifi.Messages;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class WifiNetworkManager {
    private static final String INTERFACE_NAME_PROPERTY = "wifi.interface.name";
    private static final String EMPTY_STRING = "";
    private final WifiManager wifiManager;
    private NetworkInterface wifiInterface;
    private AccessPointConfiguration configurationAP;
    private SoftAPConfiguration softAPConfiguration;
    private boolean scanWhileSoftAP;
    private boolean isSoftAP;
    private IPConfiguration clientIPConfiguration;
    private IPConfiguration softAPIPConfiguration;
    private String interfaceName = System.getProperty("wifi.interface.name");

    public WifiNetworkManager() throws IOException {
        this(new AccessPointConfiguration(EMPTY_STRING), new SoftAPConfiguration());
    }

    public WifiNetworkManager(@NonNull AccessPointConfiguration configurationAP, @NonNull SoftAPConfiguration softAPConfiguration) throws IOException, NullPointerException {
        if (configurationAP == null || softAPConfiguration == null) {
            throw new NullPointerException();
        }
        this.configurationAP = configurationAP;
        this.softAPConfiguration = softAPConfiguration;
        this.wifiManager = WifiManager.getInstance();
        if (this.wifiManager == null) {
            throw new NullPointerException(Messages.BUILDER.buildMessage('S', Messages.WIFI_CATEGORY, -4));
        }
        this.wifiInterface = null;
        this.scanWhileSoftAP = true;
        this.isSoftAP = false;
        this.clientIPConfiguration = this.getDefaultIPConfiguration();
        this.initNetwork();
    }

    public boolean isInit() {
        return this.wifiInterface != null && NetworkInterfaceManager.isEnabled((NetworkInterface)this.wifiInterface);
    }

    public AccessPoint[] scanAccessPoints() throws IOException {
        AccessPoint[] scan;
        boolean wasMounted = false;
        if (!this.scanWhileSoftAP && this.isSoftAP) {
            wasMounted = true;
            this.unmountSoftAccessPoint();
        }
        try {
            scan = this.wifiManager.scan(false);
        }
        catch (IOException e) {
            if (this.scanWhileSoftAP && this.isSoftAP) {
                this.setScanWhileSoftAP(false);
                scan = this.scanAccessPoints();
                wasMounted = false;
            }
            throw new IOException(e);
        }
        if (wasMounted) {
            this.mountSoftAccessPoint();
        }
        return scan;
    }

    public void joinAccessPoint(int timeout) throws IOException, NullPointerException, UnsupportedOperationException, IllegalArgumentException {
        AccessPoint accessPoint = this.configurationAP.getAccessPoint();
        if (accessPoint != null) {
            this.joinAccessPoint(accessPoint, this.configurationAP.getPassphrase(), timeout);
        } else {
            this.joinAccessPoint(this.configurationAP.getSSID(), this.configurationAP.getPassphrase(), this.configurationAP.getSecurityMode(), timeout);
        }
    }

    public void joinAccessPoint(@NonNull AccessPoint access, @Nullable String password, int timeout) throws IOException, NullPointerException, UnsupportedOperationException, IllegalArgumentException {
        AccessPoint joinedAP;
        if (this.wifiManager.getCapability() == WifiCapability.SOFT_AP) {
            throw new UnsupportedOperationException();
        }
        if (access == null) {
            throw new NullPointerException();
        }
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        if (this.isSoftAP && this.wifiManager.getCapability() != WifiCapability.BOTH_SIMULTANEOUS) {
            try {
                this.unmountSoftAccessPoint();
            }
            catch (IOException e) {
                Messages.LOGGER.log('I', Messages.WIFI_CATEGORY, -1, (Throwable)e);
            }
        }
        if (!access.equals(joinedAP = this.getJoinedAccessPoint())) {
            if (joinedAP != null) {
                try {
                    this.leaveAccessPoint();
                }
                catch (IOException e) {
                    Messages.LOGGER.log('I', Messages.WIFI_CATEGORY, -2, (Throwable)e);
                }
            }
            this.setCurrentIPConfiguration(this.clientIPConfiguration);
            this.wifiManager.join(access, password);
        }
        this.checkJoinedAP(timeout);
    }

    public void joinAccessPoint(@NonNull String ssid, @Nullable String password, @Nullable SecurityMode securityMode, int timeout) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        AccessPoint joinedAP;
        if (this.wifiManager.getCapability() == WifiCapability.SOFT_AP) {
            throw new UnsupportedOperationException();
        }
        if (this.isSoftAP && this.wifiManager.getCapability() != WifiCapability.BOTH_SIMULTANEOUS) {
            try {
                this.unmountSoftAccessPoint();
            }
            catch (IOException e) {
                Messages.LOGGER.log('I', Messages.WIFI_CATEGORY, -1, (Throwable)e);
            }
        }
        if ((joinedAP = this.getJoinedAccessPoint()) == null || !ssid.equals(joinedAP.getSSID())) {
            if (joinedAP != null) {
                try {
                    this.leaveAccessPoint();
                }
                catch (IOException e) {
                    Messages.LOGGER.log('I', Messages.WIFI_CATEGORY, -2, (Throwable)e);
                }
            }
            this.setCurrentIPConfiguration(this.clientIPConfiguration);
            password = this.sanitizePassword(password);
            if (securityMode == null) {
                this.wifiManager.join(ssid, password);
            } else {
                this.wifiManager.join(ssid, password, securityMode);
            }
        }
        this.checkJoinedAP(timeout);
    }

    public void leaveAccessPoint() throws IOException {
        AccessPoint joinedAP = this.getJoinedAccessPoint();
        if (joinedAP == null) {
            throw new IOException(Messages.BUILDER.buildMessage('S', Messages.WIFI_CATEGORY, -5));
        }
        this.wifiManager.leave();
        this.configurationAP.setAccessPoint(null);
    }

    public boolean isConnected() throws IOException {
        return this.getJoinedAccessPoint() != null;
    }

    public boolean isSoftAPEnabled() throws IOException {
        this.isSoftAP = this.wifiManager.isSoftAPEnabled();
        return this.isSoftAP;
    }

    public AccessPoint getJoinedAccessPoint() throws IOException {
        AccessPoint joined = null;
        if (!this.isSoftAP || this.wifiManager.getCapability() == WifiCapability.BOTH_SIMULTANEOUS) {
            joined = this.wifiManager.getJoined();
        }
        return joined;
    }

    public AccessPointConfiguration getAPConfiguration() {
        return this.configurationAP;
    }

    public void setAPConfiguration(@NonNull AccessPointConfiguration configurationAP) {
        if (configurationAP == null) {
            throw new NullPointerException();
        }
        this.configurationAP = configurationAP;
    }

    public SoftAPConfiguration getSoftAPConfiguration() {
        return this.softAPConfiguration;
    }

    public void setSoftAPConfiguration(@NonNull SoftAPConfiguration softAPConfiguration) throws NullPointerException {
        if (softAPConfiguration == null) {
            throw new NullPointerException();
        }
        this.softAPConfiguration = softAPConfiguration;
    }

    public void mountSoftAccessPoint() throws IOException {
        this.mountSoftAccessPoint(this.softAPConfiguration);
    }

    public void mountSoftAccessPoint(@NonNull SoftAPConfiguration config) throws IOException, UnsupportedOperationException {
        this.setSoftAPConfiguration(config);
        if (this.wifiManager.getCapability() == WifiCapability.CLIENT) {
            throw new UnsupportedOperationException();
        }
        if (this.isConnected() && this.wifiManager.getCapability() != WifiCapability.BOTH_SIMULTANEOUS) {
            try {
                this.leaveAccessPoint();
            }
            catch (IOException e) {
                Messages.LOGGER.log('I', Messages.WIFI_CATEGORY, -2, (Throwable)e);
            }
        }
        if (config.getSSID() == null) {
            throw new IllegalArgumentException(Messages.BUILDER.buildMessage('S', Messages.WIFI_CATEGORY, -6));
        }
        this.setCurrentIPConfiguration(this.softAPIPConfiguration);
        if (config.getName() == null) {
            config.setName(config.getSSID());
        }
        this.wifiManager.enableSoftAP(config);
        this.isSoftAP = true;
    }

    public void unmountSoftAccessPoint() throws IOException {
        if (this.isSoftAP) {
            this.wifiManager.disableSoftAP();
            this.isSoftAP = false;
        }
    }

    public boolean supportScanWhileSoftAP() {
        return this.scanWhileSoftAP;
    }

    public void setScanWhileSoftAP(boolean scanWhileSoftAP) {
        this.scanWhileSoftAP = scanWhileSoftAP;
    }

    public WifiCapability getCapabilities() throws IOException {
        return this.wifiManager.getCapability();
    }

    public void setClientIPConfigure(@Nullable IPConfiguration ipConfiguration) {
        this.clientIPConfiguration = ipConfiguration;
    }

    public void setSoftAPIPConfigure(@Nullable IPConfiguration softAPIPConfiguration) {
        this.softAPIPConfiguration = softAPIPConfiguration;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(@Nullable String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public WifiManager getWifiManager() {
        return this.wifiManager;
    }

    public NetworkInterface getWifiInterface() {
        if (this.wifiInterface == null) {
            try {
                this.updateInterface();
            }
            catch (IOException iOException) {}
        }
        return this.wifiInterface;
    }

    private void setCurrentIPConfiguration(IPConfiguration ipConfiguration) throws IOException {
        IPConfiguration oldConfiguration;
        NetworkInterface networkInterface = this.wifiInterface;
        if (networkInterface != null && ipConfiguration != null && !ipConfiguration.equals(oldConfiguration = NetworkInterfaceManager.getIPConfiguration((NetworkInterface)networkInterface))) {
            NetworkInterfaceManager.configure((NetworkInterface)networkInterface, (IPConfiguration)ipConfiguration);
        }
    }

    private void checkJoinedAP(int timeout) throws IOException {
        this.waitUntilIpIsAssigned(timeout);
        AccessPoint joinedAP = this.getJoinedAccessPoint();
        if (joinedAP == null) {
            throw new IOException(Messages.BUILDER.buildMessage('S', Messages.WIFI_CATEGORY, -5));
        }
        this.configurationAP.setAccessPoint(joinedAP);
    }

    private String sanitizePassword(String password) {
        return password == null ? EMPTY_STRING : password;
    }

    private void updateInterface() throws IOException {
        NetworkInterface wifiInterface = this.wifiInterface;
        String name = this.interfaceName;
        wifiInterface = name != null ? NetUtil.getInterface((String)name) : this.getDefaultInterface();
        this.wifiInterface = wifiInterface;
    }

    private NetworkInterface getDefaultInterface() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        NetworkInterface networkInterface = null;
        while (interfaces.hasMoreElements()) {
            NetworkInterface currentInterface = interfaces.nextElement();
            if (currentInterface.isLoopback()) continue;
            if (currentInterface.isUp()) {
                Enumeration<InetAddress> inetAddresses = currentInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!NetUtil.isValidInetAdress((InetAddress)inetAddress)) continue;
                    return currentInterface;
                }
                networkInterface = currentInterface;
                continue;
            }
            if (networkInterface != null) continue;
            networkInterface = currentInterface;
        }
        return networkInterface;
    }

    private void waitUntilIpIsAssigned(int timeout) throws IOException {
        boolean validIp = false;
        long timeoutTimeMillis = Util.platformTimeMillis() + (long)timeout;
        block0: while (!validIp) {
            this.updateInterface();
            if (timeout != 0 && timeoutTimeMillis < Util.platformTimeMillis()) {
                throw new IOException(Messages.BUILDER.buildMessage('S', Messages.WIFI_CATEGORY, -3));
            }
            Enumeration<InetAddress> inetAdresses = this.wifiInterface.getInetAddresses();
            while (inetAdresses.hasMoreElements()) {
                InetAddress inetAddress = inetAdresses.nextElement();
                if (!NetUtil.isValidInetAdress((InetAddress)inetAddress)) continue;
                validIp = true;
                continue block0;
            }
        }
    }

    private IPConfiguration getDefaultIPConfiguration() {
        IPConfiguration clientIPConfiguration = new IPConfiguration();
        clientIPConfiguration.useDHCP(true);
        clientIPConfiguration.useStaticDNS(false);
        return clientIPConfiguration;
    }

    private void initNetwork() throws IOException {
        this.updateInterface();
        if (this.wifiInterface == null) {
            throw new IOException(Messages.BUILDER.buildMessage('S', Messages.WIFI_CATEGORY, -4));
        }
        if (!NetworkInterfaceManager.isStarted((NetworkInterface)this.wifiInterface)) {
            NetworkInterfaceManager.start((NetworkInterface)this.wifiInterface);
        }
        if (!NetworkInterfaceManager.isEnabled((NetworkInterface)this.wifiInterface)) {
            NetworkInterfaceManager.enable((NetworkInterface)this.wifiInterface);
        }
        this.isSoftAPEnabled();
        this.configurationAP.setAccessPoint(this.wifiManager.getJoined());
    }
}

