/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.container;

import ej.basictool.map.PackedMap;
import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.util.Rectangle;
import ej.mwt.util.Size;

public class Canvas
extends Container {
    private final PackedMap<Widget, Rectangle> widgetBounds = new PackedMap();

    public void addChild(Widget child, int x, int y, int width, int height) {
        super.addChild(child);
        this.widgetBounds.put((Object)child, (Object)new Rectangle(x, y, width, height));
    }

    public void removeChild(Widget child) {
        super.removeChild(child);
        this.widgetBounds.remove((Object)child);
    }

    public void removeAllChildren() {
        super.removeAllChildren();
        this.widgetBounds.clear();
    }

    public void changeChildIndex(Widget child, int index) {
        super.changeChildIndex(child, index);
    }

    protected void computeContentOptimalSize(Size size) {
        int widthHint = size.getWidth();
        int heightHint = size.getHeight();
        PackedMap<Widget, Rectangle> widgetBounds = this.widgetBounds;
        int width = 0;
        int height = 0;
        Widget[] widgetArray = this.getChildren();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget child = widgetArray[n2];
            assert (child != null);
            Rectangle bounds = (Rectangle)widgetBounds.get((Object)child);
            int childX = bounds.getX();
            int childY = bounds.getY();
            int childWidth = bounds.getWidth();
            int childHeight = bounds.getHeight();
            int childWidthHint = Canvas.getChildSize(childWidth, widthHint);
            int childHeightHint = Canvas.getChildSize(childHeight, heightHint);
            this.computeChildOptimalSize(child, childWidthHint, childHeightHint);
            childWidth = Canvas.getChildSize(childWidth, child.getWidth());
            childHeight = Canvas.getChildSize(childHeight, child.getHeight());
            width = Math.max(width, childX + childWidth);
            height = Math.max(height, childY + childHeight);
            ++n2;
        }
        size.setSize(width, height);
    }

    protected void layOutChildren(int contentWidth, int contentHeight) {
        Widget[] widgetArray = this.getChildren();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget child = widgetArray[n2];
            assert (child != null);
            Rectangle bounds = (Rectangle)this.widgetBounds.get((Object)child);
            int childWidth = Canvas.getChildSize(bounds.getWidth(), child.getWidth());
            int childHeight = Canvas.getChildSize(bounds.getHeight(), child.getHeight());
            this.layOutChild(child, bounds.getX(), bounds.getY(), childWidth, childHeight);
            ++n2;
        }
    }

    private static int getChildSize(int sizeHint, int optimalSize) {
        return sizeHint == 0 ? optimalSize : sizeHint;
    }
}

