/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import ej.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedOutputStream;

public class PipedInputStream
extends InputStream {
    boolean closedByWriter = false;
    volatile boolean closedByReader = false;
    boolean connected = false;
    @Nullable
    Thread readSide;
    @Nullable
    Thread writeSide;
    private static final int DEFAULT_PIPE_SIZE = 1024;
    protected static final int PIPE_SIZE = 1024;
    protected byte[] buffer;
    protected int in = -1;
    protected int out = 0;

    public PipedInputStream(PipedOutputStream src) throws IOException {
        this(src, 1024);
    }

    public PipedInputStream(PipedOutputStream src, int pipeSize) throws IOException {
        if (pipeSize <= 0) {
            throw new IllegalArgumentException("Pipe Size <= 0");
        }
        this.buffer = new byte[pipeSize];
        this.connect(src);
    }

    public PipedInputStream() {
        this.buffer = new byte[1024];
    }

    public PipedInputStream(int pipeSize) {
        if (pipeSize <= 0) {
            throw new IllegalArgumentException("Pipe Size <= 0");
        }
        this.buffer = new byte[pipeSize];
    }

    public void connect(PipedOutputStream src) throws IOException {
        src.connect(this);
    }

    protected synchronized void receive(int b) throws IOException {
        this.checkStateForReceive();
        this.writeSide = Thread.currentThread();
        if (this.in == this.out) {
            this.awaitSpace();
        }
        if (this.in < 0) {
            this.in = 0;
            this.out = 0;
        }
        this.buffer[this.in++] = (byte)(b & 0xFF);
        if (this.in >= this.buffer.length) {
            this.in = 0;
        }
    }

    synchronized void receive(byte[] b, int off, int len) throws IOException {
        this.checkStateForReceive();
        this.writeSide = Thread.currentThread();
        int bytesToTransfer = len;
        while (bytesToTransfer > 0) {
            if (this.in == this.out) {
                this.awaitSpace();
            }
            int nextTransferAmount = 0;
            if (this.out < this.in) {
                nextTransferAmount = this.buffer.length - this.in;
            } else if (this.in < this.out) {
                if (this.in == -1) {
                    this.out = 0;
                    this.in = 0;
                    nextTransferAmount = this.buffer.length - this.in;
                } else {
                    nextTransferAmount = this.out - this.in;
                }
            }
            if (nextTransferAmount > bytesToTransfer) {
                nextTransferAmount = bytesToTransfer;
            }
            assert (nextTransferAmount > 0);
            System.arraycopy(b, off, this.buffer, this.in, nextTransferAmount);
            bytesToTransfer -= nextTransferAmount;
            off += nextTransferAmount;
            this.in += nextTransferAmount;
            if (this.in < this.buffer.length) continue;
            this.in = 0;
        }
    }

    private void checkStateForReceive() throws IOException {
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByWriter || this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        Thread readSide = this.readSide;
        if (readSide != null && !readSide.isAlive()) {
            throw new IOException("Read end dead");
        }
    }

    private void awaitSpace() throws IOException {
        while (this.in == this.out) {
            this.checkStateForReceive();
            this.notifyAll();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
    }

    synchronized void receivedLast() {
        this.closedByWriter = true;
        this.notifyAll();
    }

    @Override
    public synchronized int read() throws IOException {
        Thread writeSide = this.writeSide;
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        if (writeSide != null && !writeSide.isAlive() && !this.closedByWriter && this.in < 0) {
            throw new IOException("Write end dead");
        }
        this.readSide = Thread.currentThread();
        int trials = 2;
        while (this.in < 0) {
            if (this.closedByWriter) {
                return -1;
            }
            if (writeSide != null && !writeSide.isAlive() && --trials < 0) {
                throw new IOException("Pipe broken");
            }
            this.notifyAll();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        int ret = this.buffer[this.out++] & 0xFF;
        if (this.out >= this.buffer.length) {
            this.out = 0;
        }
        if (this.in == this.out) {
            this.in = -1;
        }
        return ret;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int length = b.length;
        if (off < 0 || len < 0 || len > length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c < 0) {
            return -1;
        }
        b[off] = (byte)c;
        int rlen = 1;
        while (this.in >= 0 && len > 1) {
            int available = this.in > this.out ? Math.min(this.buffer.length - this.out, this.in - this.out) : this.buffer.length - this.out;
            if (available > len - 1) {
                available = len - 1;
            }
            System.arraycopy(this.buffer, this.out, b, off + rlen, available);
            this.out += available;
            rlen += available;
            len -= available;
            if (this.out >= this.buffer.length) {
                this.out = 0;
            }
            if (this.in != this.out) continue;
            this.in = -1;
        }
        return rlen;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.in < 0) {
            return 0;
        }
        if (this.in == this.out) {
            return this.buffer.length;
        }
        if (this.in > this.out) {
            return this.in - this.out;
        }
        return this.in + this.buffer.length - this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.closedByReader = true;
        PipedInputStream pipedInputStream = this;
        synchronized (pipedInputStream) {
            this.in = -1;
        }
    }
}

