/*
 * Decompiled with CFR 0.152.
 */
package ej.fp;

import ej.fp.Composite;
import ej.fp.EventQueue;
import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.Widget;
import java.util.ArrayList;
import java.util.List;

public abstract class Device
extends Composite {
    private final EventQueue eventGenerator;

    public Device(String name, Image skin) {
        this.setSkin(skin);
        this.setLabel(name);
        this.eventGenerator = new EventQueue();
    }

    public static Device getDevice() {
        return FrontPanel.getFrontPanel().getDevice();
    }

    public String getName() {
        return this.getLabel();
    }

    public List<Widget> getWidgets() {
        ArrayList<Widget> widgets = new ArrayList<Widget>(0);
        for (Widget widget : this) {
            widgets.add(widget);
        }
        return widgets;
    }

    public <T> List<T> getWidgets(Class<T> clazz) {
        ArrayList<T> widgets = new ArrayList<T>(0);
        for (Widget widget : this) {
            if (!clazz.isInstance(widget)) continue;
            T t = clazz.cast(widget);
            widgets.add(t);
        }
        return widgets;
    }

    public <T> T getWidget(Class<T> clazz) {
        return this.getWidget(clazz, null);
    }

    public <T> T getWidget(Class<T> clazz, String label) {
        for (Widget widget : this) {
            if (!clazz.isInstance(widget) || label != null && !label.equals(widget.getLabel())) continue;
            return clazz.cast(widget);
        }
        return null;
    }

    public EventQueue getEventQueue() {
        return this.eventGenerator;
    }
}

