/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import com.is2t.tools.GeometryTools;
import ej.annotation.NonNull;
import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;
import ej.microui.util.EventHandler;
import ej.mwt.Composite;
import ej.mwt.Desktop;
import ej.mwt.Panel;
import ej.mwt.Renderable;
import ej.mwt.RenderableHelper;
import ej.mwt.RepaintRenderable;

public abstract class Widget
implements Renderable {
    private static final int ENABLED_SHIFT = 0;
    private static final int ENABLED_MASK = 1;
    private static final int VISIBLE_SHIFT = 1;
    private static final int VISIBLE_MASK = 2;
    short x;
    short y;
    short width;
    short height;
    Panel panel;
    Composite parent;
    @Nullable
    private EventHandler eventHandler;
    boolean visible = true;
    private boolean enabled = true;
    private short preferredWidth;
    private short preferredHeight;

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredSize(int preferredWidth, int preferredHeight) {
        this.preferredWidth = (short)preferredWidth;
        this.preferredHeight = (short)preferredHeight;
    }

    public void setLocation(int x, int y) {
        this.setBounds(x, y, this.width, this.height);
    }

    public void setSize(int width, int height) {
        this.setBounds(this.x, this.y, width, height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.simpleUdpate(x, y, Math.max(0, width), Math.max(0, height));
    }

    private void simpleUdpate(int x, int y, int width, int height) {
        this.x = (short)x;
        this.y = (short)y;
        this.width = (short)width;
        this.height = (short)height;
    }

    @Override
    public void showNotify() {
    }

    @Override
    public void hideNotify() {
    }

    public int getAbsoluteX() throws IllegalArgumentException {
        if (this.panel == null) {
            throw new IllegalArgumentException();
        }
        return this.getAbsoluteXInternal();
    }

    int getAbsoluteXInternal() {
        int absoluteX = this.x;
        Composite parent = this.getParent();
        if (parent != null) {
            absoluteX += parent.getAbsoluteXInternal();
        } else {
            Panel panel = this.getPanel();
            if (panel != null) {
                absoluteX += panel.x;
            }
        }
        return absoluteX;
    }

    public int getAbsoluteY() throws IllegalArgumentException {
        if (this.panel == null) {
            throw new IllegalArgumentException();
        }
        return this.getAbsoluteYInternal();
    }

    int getAbsoluteYInternal() {
        int absoluteY = this.y;
        Composite parent = this.getParent();
        if (parent != null) {
            absoluteY += parent.getAbsoluteYInternal();
        } else {
            Panel panel = this.getPanel();
            if (panel != null) {
                absoluteY += panel.y;
            }
        }
        return absoluteY;
    }

    public int getRelativeX(int absoluteX) throws IllegalArgumentException {
        return absoluteX - this.getAbsoluteX();
    }

    public int getRelativeY(int absoluteY) throws IllegalArgumentException {
        return absoluteY - this.getAbsoluteY();
    }

    public int getAbsoluteX(int relativeX) {
        return relativeX + this.getAbsoluteX();
    }

    public int getAbsoluteY(int relativeY) {
        return relativeY + this.getAbsoluteY();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        Panel panel = this.panel;
        if (this.isShown() && !panel.isValidating()) {
            this.invalidate();
        }
    }

    public boolean isTransparent() {
        return true;
    }

    public boolean contains(int x, int y) {
        return GeometryTools.contains((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)x, (int)y);
    }

    @Nullable
    public Widget getWidgetAt(int x, int y) {
        if (this.contains(x, y)) {
            return this;
        }
        return null;
    }

    public boolean hasFocus() {
        try {
            return this.panel.isActive() && this.isFocusOwner();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    boolean isFocusOwner() {
        try {
            return this.panel.getFocus() == this;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public void requestFocus() {
        try {
            this.panel.setFocus(this);
        }
        catch (NullPointerException nullPointerException) {}
    }

    public boolean requestFocus(int direction) {
        if (this.isEnabled()) {
            this.requestFocus();
            return true;
        }
        return false;
    }

    public void gainFocus() {
    }

    public void lostFocus() {
    }

    public boolean isEnabled() {
        return this.visible && this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.enabled;
        if (wasEnabled != enabled) {
            this.enabled = enabled;
            this.repaint();
        }
    }

    public void invalidate() {
        Panel panel = this.panel;
        if (panel != null) {
            panel.invalidate();
        }
    }

    public void revalidate() {
        Panel panel = this.panel;
        if (panel != null) {
            panel.revalidate();
        }
    }

    public void revalidateSubTree() {
        Desktop desktop;
        final Panel panel = this.panel;
        if (panel != null && (desktop = panel.getDesktop()) != null && desktop.isShown()) {
            desktop.getDisplay().callSerially(new Runnable(){

                @Override
                public void run() {
                    panel.startValidating();
                    Widget widget = Widget.this;
                    short width = widget.width;
                    short height = widget.height;
                    Widget.this.validate(width, height);
                    Widget.this.setBounds(widget.x, widget.y, width, height);
                    panel.stopValidating();
                    Widget.this.repaint();
                }
            });
        }
    }

    public abstract void validate(int var1, int var2);

    public boolean isValid() {
        if (this.panel != null) {
            return this.visible && this.panel.isValid();
        }
        return false;
    }

    @Nullable
    public Composite getParent() {
        return this.parent;
    }

    @Nullable
    public Panel getPanel() {
        return this.panel;
    }

    @Override
    public boolean isShown() {
        Panel panel = this.panel;
        return panel != null && panel.isShown();
    }

    @Override
    public void repaint() {
        this.repaintInternal(0, 0, this.width, this.height);
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        if (x < 0) {
            width += x;
            x = 0;
        }
        if (y < 0) {
            height += y;
            y = 0;
        }
        width = Math.min(this.width - x, width);
        height = Math.min(this.height - y, height);
        if (width <= 0 || height <= 0) {
            return;
        }
        this.repaintInternal(x, y, width, height);
    }

    @Override
    public void setEventHandler(@Nullable EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    @Nullable
    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public boolean handleEvent(int event) {
        return RenderableHelper.handleEvent(event, this.eventHandler);
    }

    void setParent(@Nullable Composite parent) {
        this.setPanel(parent == null ? null : parent.panel);
        this.parent = parent;
    }

    void setPanel(@Nullable Panel panel) {
        Panel oldPanel = this.panel;
        if (panel != null) {
            this.setPanelOnly(panel);
            if (oldPanel == null && panel.isShown()) {
                this.showNotify();
            }
        } else {
            if (oldPanel != null && oldPanel.isShown()) {
                this.hideNotify();
            }
            this.setPanelOnly(null);
        }
    }

    void setPanelOnly(@Nullable Panel panel) {
        this.panel = panel;
    }

    void paint(@NonNull GraphicsContext g) {
        Panel panel = this.panel;
        if (panel != null) {
            Desktop desktop = panel.getDesktop();
            RenderableHelper.paintRenderable(g, desktop, this);
        }
    }

    void paint(@NonNull GraphicsContext g, int translateX, int translateY, int x, int y, int width, int height) {
        if (!this.visible) {
            return;
        }
        this.beforePaint(g, translateX, translateY, x, y, width, height);
        this.paint(g);
    }

    void beforePaint(@NonNull GraphicsContext g, int translateX, int translateY, int x, int y, int width, int height) {
        g.translate(-g.getTranslateX(), -g.getTranslateY());
        g.setSystemClip(translateX + x, translateY + y, width, height);
        g.translate(translateX + this.x, translateY + this.y);
        g.setClipAndUpdateSystemClip(0, 0, (int)this.width, (int)this.height);
    }

    private void repaintInternal(int x, int y, int width, int height) {
        if (!this.visible) {
            return;
        }
        Panel panel = this.panel;
        if (panel == null) {
            return;
        }
        if (this.isTransparent()) {
            Renderable target = this.parent;
            if (target == null) {
                target = panel;
            }
            target.repaint(this.x + x, this.y + y, width, height);
        } else {
            Desktop desktop = panel.getDesktop();
            if (desktop != null && desktop.isShown()) {
                if (desktop.getActivePanel() == panel) {
                    desktop.getDisplay().callSerially((Runnable)new RepaintRenderable(desktop, x, y, width, height){

                        @Override
                        protected void paint(@NonNull GraphicsContext g) {
                            g.translate(-g.getTranslateX(), -g.getTranslateY());
                            int leftX = Widget.this.getAbsoluteXInternal() + this.x;
                            int topY = Widget.this.getAbsoluteYInternal() + this.y;
                            g.setSystemClip(leftX, topY, this.width, this.height);
                            g.setClip(leftX, topY, this.width, this.height);
                            Widget.this.clipRecursive(g);
                            Widget.this.paint(g, g.getTranslateX(), g.getTranslateY(), g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
                        }
                    });
                } else {
                    desktop.repaintFrom(this, this.getAbsoluteXInternal() + x, this.getAbsoluteYInternal() + y, width, height);
                }
            }
        }
    }

    void clip(@NonNull GraphicsContext g) {
        this.clipRecursive(g);
        g.translate((int)this.x, (int)this.y);
        g.clipRect(0, 0, (int)this.width, (int)this.height);
    }

    void clipRecursive(@NonNull GraphicsContext g) {
        Composite parent = this.getParent();
        if (parent != null) {
            parent.clip(g);
        } else {
            Panel panel = this.getPanel();
            if (panel != null) {
                g.translate((int)panel.x, (int)panel.y);
                g.clipRect(0, 0, (int)panel.width, (int)panel.height);
            }
        }
    }
}

