/*
 * Decompiled with CFR 0.152.
 */
package ej.net.util;

import android.net.SntpClient;
import ej.bon.Util;
import ej.net.util.Messages;
import java.io.IOException;

public class NtpUtil {
    public static final String NTP_URL_PROPERTY = "ntp.url";
    public static final String NTP_PORT_PROPERTY = "ntp.port";
    public static final String NTP_TIMEOUT_PROPERTY = "ntp.timeout";
    public static final String NTP_ATTEMPTS_PROPERTY = "ntp.attempts";
    public static final int NTP_DEFAULT_PORT = 123;
    public static final String NTP_DEFAULT_SERVER = "0.pool.ntp.org";
    public static final int NTP_DEFAULT_TIMEOUT = 1000;
    public static final int NTP_DEFAULT_ATTEMPTS = 3;

    private NtpUtil() {
    }

    public static void updateLocalTime() throws IOException {
        String url = System.getProperty(NTP_URL_PROPERTY, NTP_DEFAULT_SERVER);
        int port = Integer.getInteger(NTP_PORT_PROPERTY, 123);
        int timeout = Integer.getInteger(NTP_TIMEOUT_PROPERTY, 1000);
        NtpUtil.updateLocalTime(url, port, timeout);
    }

    public static void updateLocalTime(String url, int port, int timeout) throws IOException {
        int attempts = Integer.getInteger(NTP_ATTEMPTS_PROPERTY, 3);
        SntpClient ntpClient = new SntpClient();
        int i = 0;
        while (i < attempts) {
            if (ntpClient.requestTime(url, port, timeout)) {
                long now = ntpClient.getNtpTime() + Util.platformTimeMillis() - ntpClient.getNtpTimeReference();
                Util.setCurrentTimeMillis((long)now);
                return;
            }
            ++i;
        }
        throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -1));
    }
}

