/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.outline;

import ej.annotation.Nullable;
import ej.bon.XMath;
import ej.microui.display.GraphicsContext;
import ej.mwt.style.outline.Outline;
import ej.mwt.util.Outlineable;
import ej.mwt.util.Size;

public class FlexibleOutline
implements Outline {
    private final char top;
    private final char bottom;
    private final char left;
    private final char right;

    public FlexibleOutline(int top, int right, int bottom, int left) {
        this.top = (char)XMath.limit((int)top, (int)0, (int)65535);
        this.right = (char)XMath.limit((int)right, (int)0, (int)65535);
        this.bottom = (char)XMath.limit((int)bottom, (int)0, (int)65535);
        this.left = (char)XMath.limit((int)left, (int)0, (int)65535);
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    @Override
    public void apply(Outlineable outlineable) {
        outlineable.removeOutline(this.left, this.top, this.right, this.bottom);
    }

    @Override
    public void apply(GraphicsContext g, Size size) {
        size.removeOutline(this.left, this.top, this.right, this.bottom);
        g.translate((int)this.left, (int)this.top);
        g.intersectClip(0, 0, size.getWidth(), size.getHeight());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            FlexibleOutline outline = (FlexibleOutline)obj;
            return this.top == outline.top && this.bottom == outline.bottom && this.left == outline.left && this.right == outline.right;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.top * this.bottom * this.left * this.right;
    }
}

