/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.util;

public class ThirdEventThread
extends Thread {
    private final ThirdEventWidget widget;
    private final Object monitor;
    private final boolean infinite;
    private boolean sendThirdEvent;
    private boolean isRunning;

    public ThirdEventThread(ThirdEventWidget widget, boolean infinite) {
        this.widget = widget;
        this.infinite = infinite;
        this.monitor = new Object();
        this.isRunning = true;
    }

    public void dispose() {
        this.isRunning = false;
        this.goToSleep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.monitor;
        synchronized (object) {
            this.sendThirdEvent = true;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goToSleep() {
        Object object = this.monitor;
        synchronized (object) {
            this.sendThirdEvent = false;
            this.monitor.notifyAll();
        }
    }

    public boolean isSendingThirdEvent() {
        return this.sendThirdEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThirdEventWidget widget = this.widget;
        while (this.isRunning) {
            Object object = this.monitor;
            synchronized (object) {
                if (!this.sendThirdEvent) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                if (this.sendThirdEvent) {
                    try {
                        this.monitor.wait(widget.getSleepPeriod());
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
            if (!this.sendThirdEvent) continue;
            widget.sendThirdEvent();
            this.sendThirdEvent = this.infinite;
        }
    }

    public static interface ThirdEventWidget {
        public int getSleepPeriod();

        public void sendThirdEvent();
    }
}

