/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.hoka.http.HTTPRequest;
import ej.hoka.http.HTTPResponse;
import ej.hoka.http.IHTTPTransferCodingHandler;
import ej.hoka.io.IdentityMessageBodyInputStream;
import ej.hoka.io.IdentityMessageBodyOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IdentityTransferCodingHandler
implements IHTTPTransferCodingHandler {
    private static IdentityTransferCodingHandler Instance;

    private IdentityTransferCodingHandler() {
    }

    public static IdentityTransferCodingHandler getInstance() {
        if (Instance == null) {
            Instance = new IdentityTransferCodingHandler();
        }
        return Instance;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public InputStream open(HTTPRequest request, InputStream input) throws IOException {
        int bodyLength = 0;
        String contentLength = request.getHeaderField("content-length");
        if (contentLength != null) {
            bodyLength = Integer.parseInt(contentLength);
        }
        return new IdentityMessageBodyInputStream(input, bodyLength);
    }

    @Override
    public OutputStream open(HTTPResponse response, OutputStream output) throws IOException {
        return new IdentityMessageBodyOutputStream(output);
    }
}

