/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.container;

import ej.annotation.Nullable;
import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.util.Size;

public class FixedGrid
extends Container {
    private final int columns;
    private final int rows;
    private final Widget[] children;

    public FixedGrid(int columns, int rows) {
        if (columns <= 0 || rows <= 0) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.rows = rows;
        this.children = new Widget[columns * rows];
    }

    private int getIndex(int column, int row) {
        if (column >= this.columns || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        return column + row * this.columns;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    @Nullable
    public Widget getCellChild(int column, int row) {
        int index = this.getIndex(column, row);
        return this.children[index];
    }

    public void addChild(Widget child, int column, int row) {
        int index = this.getIndex(column, row);
        Widget previousWidget = this.children[index];
        if (previousWidget != null) {
            this.removeChild(previousWidget);
        }
        this.children[index] = child;
        this.addChild(child);
    }

    public void removeChild(int column, int row) {
        int index = this.getIndex(column, row);
        Widget previousWidget = this.children[index];
        if (previousWidget != null) {
            this.children[index] = null;
            this.removeChild(previousWidget);
        }
    }

    public void removeAllChildren() {
        super.removeAllChildren();
    }

    protected void computeContentOptimalSize(Size size) {
        int childrenCount = this.getChildrenCount();
        if (childrenCount == 0) {
            size.setSize(0, 0);
            return;
        }
        int widthHint = size.getWidth();
        int heightHint = size.getHeight();
        int childWidthHint = widthHint == 0 ? 0 : widthHint / this.columns;
        int childHeightHint = heightHint == 0 ? 0 : heightHint / this.rows;
        int maxCellWidth = 0;
        int maxCellHeight = 0;
        Widget[] widgetArray = this.getChildren();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            assert (widget != null);
            this.computeChildOptimalSize(widget, childWidthHint, childHeightHint);
            maxCellWidth = Math.max(maxCellWidth, widget.getWidth());
            maxCellHeight = Math.max(maxCellHeight, widget.getHeight());
            ++n2;
        }
        size.setSize(maxCellWidth * this.columns, maxCellHeight * this.rows);
    }

    protected void layOutChildren(int contentWidth, int contentHeight) {
        int childrenCount = this.getChildrenCount();
        if (childrenCount == 0) {
            return;
        }
        float columnWidthF = (float)contentWidth / (float)this.columns;
        float rowHeightF = (float)contentHeight / (float)this.rows;
        int index = 0;
        float xF = 0.0f;
        float yF = 0.0f;
        int r = 0;
        while (r < this.rows) {
            int childY = Math.round(yF);
            float nextYF = yF + rowHeightF;
            int childHeight = Math.round(nextYF) - childY;
            int c = 0;
            while (c < this.columns) {
                Widget child = this.children[index];
                float nextXF = xF + columnWidthF;
                int childX = Math.round(xF);
                int childWidth = Math.round(nextXF) - childX;
                if (child != null) {
                    this.layOutChild(child, childX, childY, childWidth, childHeight);
                }
                xF = nextXF;
                ++index;
                ++c;
            }
            yF = nextYF;
            xF = 0.0f;
            ++r;
        }
    }
}

