/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.hoka.http.HTTPRequest;
import ej.hoka.http.HTTPResponse;
import ej.hoka.http.HTTPServer;
import ej.hoka.http.IHTTPEncodingHandler;
import ej.hoka.http.body.BodyParserFactory;
import ej.hoka.http.support.AcceptEncoding;
import ej.hoka.http.support.QualityArgument;
import ej.hoka.log.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;

public abstract class HTTPSession {
    private static final int BUFFER_SIZE = 2048;
    private static final String BUFFER_SIZE_PROPERTY = "hoka.buffer.size";
    private static final String RESPONSE_HTTP11 = "HTTP/1.1 ";
    private static final String RESPONSE_COLON = ": ";
    private static final String RESPONSE_CONTENTTYPE = "content-type: ";
    private final HTTPServer server;
    private Socket streamConnection;
    private BodyParserFactory bodyParserFactory;

    public HTTPSession(HTTPServer server) {
        this.server = server;
    }

    public static HTTPResponse createErrorResponse(String status, String msg) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><head><title>");
        buffer.append(status);
        buffer.append("</title></head><body><h1>");
        buffer.append(status);
        buffer.append("</h1><p>");
        buffer.append(msg);
        buffer.append("</p></body></html>");
        HTTPResponse response = new HTTPResponse(buffer.toString());
        response.setMimeType("text/html");
        response.setStatus(status);
        return response;
    }

    protected abstract HTTPResponse answer(HTTPRequest var1);

    protected boolean checkHTTPError(HTTPResponse response) {
        return response.getStatus() != "200 OK";
    }

    protected void closeConnection() {
        try {
            this.streamConnection.close();
        }
        catch (Throwable throwable) {}
        this.streamConnection = null;
    }

    protected IHTTPEncodingHandler getAcceptEncodingHandler(String encodingParam) {
        AcceptEncoding acceptEncoding = new AcceptEncoding();
        acceptEncoding.parse(encodingParam);
        QualityArgument[] encodings = acceptEncoding.getEncodings();
        int nbEncodings = encodings.length;
        boolean[] processed = new boolean[nbEncodings];
        int pass = nbEncodings;
        while (--pass >= 0) {
            float localMax = 0.0f;
            int ptrMax = -1;
            int i = nbEncodings;
            while (--i >= 0) {
                QualityArgument arg;
                float qvalue;
                if (processed[i] || !((qvalue = (arg = encodings[i]).getQuality()) > localMax)) continue;
                localMax = qvalue;
                ptrMax = i;
            }
            processed[ptrMax] = true;
            IHTTPEncodingHandler handler = this.server.getEncodingHandler(encodings[ptrMax].getArgument());
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    protected Runnable getRunnable() {
        return new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    protected void sendError(String status) {
        this.sendError(status, null);
    }

    protected void sendError(String status, String msg) {
        Messages.LOGGER.log('I', "Hoka", 5, new Object[]{status, msg});
        this.sendResponse(HTTPSession.createErrorResponse(status, msg), null);
    }

    protected void sendResponse(HTTPResponse response, IHTTPEncodingHandler encodingHandler) {
        try {
            if (encodingHandler != null) {
                response.addHeaderField("content-encoding", encodingHandler.getId());
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream out = this.streamConnection.getOutputStream();){
                this.writeResponse(response, encodingHandler, out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Messages.LOGGER.log('S', "Hoka", -255, (Throwable)e);
        }
    }

    protected void setCurrentConnection(Socket c) {
        this.streamConnection = c;
    }

    private void writeHTTPHeader(HTTPResponse response, OutputStream output) throws IOException {
        byte[] eofHeader = "\r\n".getBytes();
        output.write(RESPONSE_HTTP11.getBytes());
        output.write(response.getStatus().getBytes());
        output.write(32);
        output.write(eofHeader);
        String mimeType = response.getMimeType();
        if (mimeType != null) {
            output.write(RESPONSE_CONTENTTYPE.getBytes());
            output.write(mimeType.getBytes());
            output.write(eofHeader);
        }
        Map<String, String> header = response.getHeader();
        for (Map.Entry<String, String> entry : header.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            output.write(key.getBytes());
            output.write(RESPONSE_COLON.getBytes());
            output.write(value.getBytes());
            output.write(eofHeader);
        }
        output.write(eofHeader);
    }

    protected void writeResponse(HTTPResponse response, IHTTPEncodingHandler encodingHandler, OutputStream output) throws IOException {
        block55: {
            byte[] rawData = response.getRawData();
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream dataStream = response.getData();){
                long length = response.getLength();
                if (length < 0L) {
                    response.addHeaderField("transfer-encoding", this.server.getChunkedTransferCodingHandler().getId());
                }
                this.writeHTTPHeader(response, output);
                if (rawData != null) {
                    Throwable throwable2 = null;
                    Object var11_16 = null;
                    try (OutputStream dataOutput = this.server.getIdentityTransferCodingHandler().open(response, output);){
                        block54: {
                            if (encodingHandler != null) {
                                Throwable throwable3 = null;
                                Object var14_26 = null;
                                try (OutputStream encodedDataOutput = encodingHandler.open(dataOutput);){
                                    this.writeAndFlush(rawData, encodedDataOutput);
                                    break block54;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    throw throwable3;
                                }
                            }
                            this.writeAndFlush(rawData, dataOutput);
                        }
                        response.setDataStreamClosed();
                        break block55;
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                if (dataStream == null) break block55;
                try {
                    try {
                        Throwable throwable6 = null;
                        Object var11_18 = null;
                        try (OutputStream dataOutput = length == -1L ? this.server.getChunkedTransferCodingHandler().open(response, output) : this.server.getIdentityTransferCodingHandler().open(response, output);){
                            Throwable throwable7 = null;
                            Object var14_28 = null;
                            try (OutputStream ecodedOutput = encodingHandler != null ? encodingHandler.open(dataOutput) : null;){
                                int len;
                                OutputStream outputStream = ecodedOutput != null ? ecodedOutput : dataOutput;
                                byte[] readBuffer = new byte[this.getBufferSize()];
                                while ((len = dataStream.read(readBuffer)) >= 0) {
                                    outputStream.write(readBuffer, 0, len);
                                    outputStream.flush();
                                }
                            }
                            catch (Throwable throwable8) {
                                if (throwable7 == null) {
                                    throwable7 = throwable8;
                                } else if (throwable7 != throwable8) {
                                    throwable7.addSuppressed(throwable8);
                                }
                                throw throwable7;
                            }
                        }
                        catch (Throwable throwable9) {
                            if (throwable6 == null) {
                                throwable6 = throwable9;
                            } else if (throwable6 != throwable9) {
                                throwable6.addSuppressed(throwable9);
                            }
                            throw throwable6;
                        }
                    }
                    catch (Throwable t) {
                        Messages.LOGGER.log('S', "Hoka", -255, t);
                        response.setDataStreamClosed();
                        break block55;
                    }
                }
                catch (Throwable throwable10) {
                    response.setDataStreamClosed();
                    throw throwable10;
                }
                response.setDataStreamClosed();
            }
            catch (Throwable throwable11) {
                if (throwable == null) {
                    throwable = throwable11;
                } else if (throwable != throwable11) {
                    throwable.addSuppressed(throwable11);
                }
                throw throwable;
            }
        }
        output.flush();
    }

    private void writeAndFlush(byte[] data, OutputStream stream) throws IOException {
        stream.write(data);
        stream.flush();
        stream.close();
    }

    public BodyParserFactory getBodyParserFactory() {
        return this.bodyParserFactory;
    }

    public void setBodyParserFactory(BodyParserFactory bodyParserFactory) {
        this.bodyParserFactory = bodyParserFactory;
    }

    private int getBufferSize() {
        return Integer.getInteger(BUFFER_SIZE_PROPERTY, 2048);
    }

    static /* synthetic */ HTTPServer access$0(HTTPSession hTTPSession) {
        return hTTPSession.server;
    }

    static /* synthetic */ int access$1(HTTPSession hTTPSession) {
        return hTTPSession.getBufferSize();
    }

    public static interface Factory {
        public HTTPSession newHTTPSession(HTTPServer var1);
    }
}

