/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.event;

import ej.fp.FrontPanel;
import ej.microui.event.LLUIInput;

public class EventPointer {
    public static final String COMMON_MICROUI_GENERATOR_TAG = "POINTER";
    private static final int POINTER_DRIVER_TYPE_SHIFT = 28;
    private static final int POINTER_DRIVER_TYPE_MASK = 0x10000000;
    private static final int POINTER_DRIVER_CMD_SHIFT = 24;
    private static final int POINTER_DRIVER_CMD_MASK = 0xF000000;
    private static final int POINTER_DRIVER_BUTTON_SHIFT = 16;
    private static final int POINTER_DRIVER_BUTTON_MASK = 0xFF0000;
    private static final int POINTER_DRIVER_DATA_SHIFT = 0;
    private static final int POINTER_DRIVER_DATA_MASK = 65535;
    private static final int POINTER_DRIVER_TYPE_ABS = 0;
    private static final int POINTER_DRIVER_TYPE_DELTA = 1;
    private static final int POINTER_DRIVER_CMD_MOVE = 0;
    private static final int POINTER_DRIVER_CMD_PRESS = 1;
    private static final int POINTER_DRIVER_CMD_RELEASE = 2;

    private EventPointer() {
    }

    public static void sendPressedEvent(int buttonId, int x, int y, boolean absolute) {
        EventPointer.sendPressedEvent(COMMON_MICROUI_GENERATOR_TAG, buttonId, x, y, absolute);
    }

    public static void sendPressedEvent(String pointerEventGenerator, int buttonId, int x, int y, boolean absolute) {
        try {
            EventPointer.sendEvents(pointerEventGenerator, 1, x, y, absolute, buttonId);
        }
        catch (IllegalArgumentException e) {
            StringBuilder buf = new StringBuilder();
            buf.append("press button ");
            buf.append(buttonId);
            buf.append(" at ");
            buf.append(x);
            buf.append(",");
            buf.append(y);
            EventPointer.traceEvent(pointerEventGenerator, buf.toString());
        }
    }

    public static void sendReleasedEvent(int buttonId) {
        EventPointer.sendReleasedEvent(COMMON_MICROUI_GENERATOR_TAG, buttonId);
    }

    public static void sendReleasedEvent(String pointerEventGenerator, int buttonId) {
        try {
            EventPointer.sendEvents(pointerEventGenerator, 2, 0, 0, false, buttonId);
        }
        catch (IllegalArgumentException e) {
            EventPointer.traceEvent(pointerEventGenerator, "release button " + buttonId);
        }
    }

    public static void sendMovedEvent(int x, int y, boolean absolute) {
        EventPointer.sendMovedEvent(COMMON_MICROUI_GENERATOR_TAG, x, y, absolute);
    }

    public static void sendMovedEvent(String pointerEventGenerator, int x, int y, boolean absolute) {
        try {
            EventPointer.sendEvents(pointerEventGenerator, 0, x, y, absolute, 0);
        }
        catch (IllegalArgumentException e) {
            StringBuilder buf = new StringBuilder();
            buf.append("move at ");
            buf.append(x);
            buf.append(",");
            buf.append(y);
            EventPointer.traceEvent(pointerEventGenerator, buf.toString());
        }
    }

    private static void sendEvents(String eventGen, int cmd, int x, int y, boolean abs, int button) {
        int eventX = x << 0 & 0xFFFF;
        int eventY = 0 | (abs ? 0 : 1) << 28 & 0x10000000 | cmd << 24 & 0xF000000 | button << 16 & 0xFF0000 | y << 0 & 0xFFFF;
        int[] events = new int[]{LLUIInput.buildEvent(eventGen, eventX), eventY};
        LLUIInput.sendEvents(events);
    }

    private static void traceEvent(String pointerEventGenerator, String desc) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(EventPointer.class.getName());
        buf.append("] ");
        buf.append(desc);
        buf.append(" (");
        buf.append(pointerEventGenerator);
        buf.append(")");
        FrontPanel.out.println(buf.toString());
    }
}

