/*
 * Decompiled with CFR 0.152.
 */
package ej.net;

import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import ej.bon.Timer;
import ej.bon.TimerTask;
import ej.net.Network;
import ej.net.util.NetUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class PollerConnectivityManager
extends ConnectivityManager {
    static final NetworkCapabilities CONNECTED = new NetworkCapabilities(new int[]{12});
    static final NetworkCapabilities UNCONNECTED = new NetworkCapabilities();
    private static final boolean DEBUG = false;
    private final Timer timer;
    private final Map<String, Network> networks = new HashMap<String, Network>();
    private static final String BASE_PROPERTY = "connectivity.";
    private static final String CONNECT = "connect.";
    private static final String CONNECT_URL_PROPERTY = "connectivity.connect.url";
    private static final String CONNECT_PORT_PROPERTY = "connectivity.connect.port";
    private static final String CONNECT_TIMEOUT_PROPERTY = "connectivity.connect.timeout";
    private static final String TASK = "task.";
    private static final String TASK_DELAY_PROPERTY = "connectivity.task.delay";
    private static final String TASK_DELAY_PERIOD_WHEN_LOST = "connectivity.task.period_when_lost";
    private static final String TASK_DELAY_PERIOD_WHEN_AVAILABLE = "connectivity.task.period_when_up";
    private static final String TASK_DELAY_PERIOD_WHEN_INTERNET = "connectivity.task.period_when_internet";
    private static final long DEFAULT_DELAY = 0L;
    private static final String EMPTY_NETWORK = "";
    private final long periodWhenLost;
    private final long periodWhenAvailable;
    private final long periodWhenInternet;
    private final String url;
    private final int port;
    private final int timeout;
    private ConnectivityManagerTimerTask pollerTask;
    private Network activeNetwork;
    private long currentPeriod;

    public PollerConnectivityManager() {
        this(new Timer());
        this.timer.schedule(new TimerTask(){

            public void run() {
                Thread.currentThread().setName(PollerConnectivityManager.class.getSimpleName());
            }
        }, 0L);
    }

    public PollerConnectivityManager(Timer timer) {
        this(timer, PollerConnectivityManager.getDefaultDelay(), PollerConnectivityManager.getDefaultPeriodWhenAvailable(), PollerConnectivityManager.getDefaultPeriodWhenLost(), PollerConnectivityManager.getDefaultPeriodWhenInternet());
    }

    public PollerConnectivityManager(Timer timer, long delay, long period) {
        this(timer, delay, period, period);
    }

    public PollerConnectivityManager(Timer timer, long delay, long periodWhenAvailable, long periodWhenLost) {
        this(timer, delay, periodWhenAvailable, periodWhenLost, periodWhenAvailable);
    }

    public PollerConnectivityManager(Timer timer, long delay, long periodWhenAvaialble, long periodWhenLost, long periodWhenInternet) {
        Network network = new Network(null);
        this.networks.put(EMPTY_NETWORK, network);
        this.timer = timer;
        this.periodWhenLost = periodWhenLost;
        this.periodWhenAvailable = periodWhenAvaialble;
        this.periodWhenInternet = periodWhenInternet;
        this.url = PollerConnectivityManager.getDefaultConnectUrl();
        this.port = PollerConnectivityManager.getDefaultConnectPort();
        this.timeout = PollerConnectivityManager.getDefaultConnectTimeout();
        this.activeNetwork = network;
        this.setActiveNetwork(network);
        this.setAvailable(false, network, this.getActiveNetworkInfo());
        this.startPolling(delay, periodWhenLost);
    }

    public void startPolling(long delay) {
        this.startPolling(delay, this.periodWhenLost);
    }

    public synchronized void stopPolling() {
        if (this.pollerTask != null) {
            this.pollerTask.cancel();
            this.pollerTask = null;
        }
    }

    public void cancel() {
        this.stopPolling();
        this.timer.cancel();
    }

    protected void log(String msg) {
    }

    protected void log(String msg, Throwable t) {
    }

    private synchronized void startPolling(long delay, long period) {
        this.stopPolling();
        this.pollerTask = new ConnectivityManagerTimerTask();
        this.currentPeriod = period;
        this.timer.schedule((TimerTask)this.pollerTask, delay, this.currentPeriod);
    }

    protected NetworkCapabilities getCapabilities(InetAddress connectedAddress) {
        NetworkCapabilities capabilities = UNCONNECTED;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Socket socket = new Socket();){
                socket.bind(new InetSocketAddress(connectedAddress, 0));
                socket.connect(new InetSocketAddress(this.url, this.port), this.timeout);
                capabilities = CONNECTED;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return capabilities;
    }

    protected Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        return NetworkInterface.getNetworkInterfaces();
    }

    protected NetworkInterface getNetworkInterface(String name) throws SocketException {
        return NetworkInterface.getByName(name);
    }

    private static String getDefaultConnectUrl() {
        String value = System.getProperty(CONNECT_URL_PROPERTY);
        Objects.requireNonNull(value, "connectivity.connect.url not set");
        return value;
    }

    private static int getDefaultConnectPort() {
        Integer value = Integer.getInteger(CONNECT_PORT_PROPERTY);
        Objects.requireNonNull(value, "connectivity.connect.port not set");
        return value;
    }

    private static int getDefaultConnectTimeout() {
        Integer value = Integer.getInteger(CONNECT_TIMEOUT_PROPERTY);
        Objects.requireNonNull(value, "connectivity.connect.timeout not set");
        return value;
    }

    private static long getDefaultDelay() {
        return Long.getLong(TASK_DELAY_PROPERTY, 0L);
    }

    private static long getDefaultPeriodWhenLost() {
        Long value = Long.getLong(TASK_DELAY_PERIOD_WHEN_LOST);
        Objects.requireNonNull(value, "connectivity.task.period_when_lost not set");
        return value;
    }

    private static long getDefaultPeriodWhenAvailable() {
        Long value = Long.getLong(TASK_DELAY_PERIOD_WHEN_AVAILABLE);
        Objects.requireNonNull(value, "connectivity.task.period_when_up not set");
        return value;
    }

    private static long getDefaultPeriodWhenInternet() {
        Long value = Long.getLong(TASK_DELAY_PERIOD_WHEN_INTERNET);
        Objects.requireNonNull(value, "connectivity.task.period_when_internet not set");
        return value;
    }

    private class ConnectivityManagerTimerTask
    extends TimerTask {
        private ConnectivityManagerTimerTask() {
        }

        public void run() {
            PollerConnectivityManager.this.log("Try connection");
            String activenetworkInterface = PollerConnectivityManager.this.activeNetwork.getNetworkInterface();
            try {
                if (PollerConnectivityManager.this.activeNetwork.getCapabilities() == CONNECTED && activenetworkInterface != null && PollerConnectivityManager.this.getCapabilities(this.checkConnected(PollerConnectivityManager.this.getNetworkInterface(activenetworkInterface))) == CONNECTED) {
                    PollerConnectivityManager.this.log("Skipped.");
                    return;
                }
            }
            catch (SocketException socketException) {}
            try {
                Enumeration<NetworkInterface> e = PollerConnectivityManager.this.getNetworkInterfaces();
                this.checkNetworkInterfacesState(e);
            }
            catch (Throwable e1) {
                PollerConnectivityManager.this.log("Error when polling", e1);
            }
        }

        private void checkNetworkInterfacesState(Enumeration<NetworkInterface> interfaces) throws SocketException {
            Network activeNetwork = PollerConnectivityManager.this.activeNetwork;
            Network internetNetwork = null;
            Network availableNetwork = null;
            Network notAvailableNetwork = null;
            Network downNetwork = null;
            for (Map.Entry network : PollerConnectivityManager.this.networks.entrySet()) {
                ((Network)((Object)network.getValue())).setPresent(false);
            }
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface n = interfaces.nextElement();
                    if (n.isLoopback()) continue;
                    Network currentNetwork = this.getNetwork(n.getName());
                    currentNetwork.setPresent(true);
                    if (n.isUp()) {
                        boolean available;
                        InetAddress connectedAddress = this.checkConnected(n);
                        boolean bl = available = connectedAddress != null;
                        if (available) {
                            NetworkCapabilities capabilities = PollerConnectivityManager.this.getCapabilities(connectedAddress);
                            if (capabilities == CONNECTED) {
                                if (internetNetwork == activeNetwork && internetNetwork != null) continue;
                                internetNetwork = currentNetwork;
                                break;
                            }
                            if (availableNetwork == activeNetwork && availableNetwork != null) continue;
                            availableNetwork = currentNetwork;
                            continue;
                        }
                        if (notAvailableNetwork == activeNetwork && notAvailableNetwork != null) continue;
                        notAvailableNetwork = currentNetwork;
                        continue;
                    }
                    if (downNetwork == activeNetwork) continue;
                    downNetwork = currentNetwork;
                }
            }
            if (internetNetwork == null) {
                Iterator iterator = PollerConnectivityManager.this.networks.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getKey() == PollerConnectivityManager.EMPTY_NETWORK || ((Network)((Object)entry.getValue())).isPresent()) continue;
                    iterator.remove();
                }
            }
            this.updateNetworkState(internetNetwork, availableNetwork, notAvailableNetwork, downNetwork, activeNetwork);
        }

        private void updateNetworkState(Network internetNetwork, Network availableNetwork, Network notAvailableNetwork, Network downNetwork, Network activeNetwork) {
            this.updatePollingRate(availableNetwork != null, internetNetwork != null);
            if (internetNetwork != null) {
                this.notify(internetNetwork, true, CONNECTED, activeNetwork);
            } else if (availableNetwork != null) {
                this.notify(availableNetwork, true, UNCONNECTED, activeNetwork);
            } else if (notAvailableNetwork != null) {
                this.notify(notAvailableNetwork, false, UNCONNECTED, activeNetwork);
            } else if (downNetwork != null) {
                this.notify(downNetwork, false, UNCONNECTED, activeNetwork);
            } else if (activeNetwork != PollerConnectivityManager.this.networks.get(PollerConnectivityManager.EMPTY_NETWORK)) {
                this.notify((Network)((Object)PollerConnectivityManager.this.networks.get(PollerConnectivityManager.EMPTY_NETWORK)), false, UNCONNECTED, activeNetwork);
            }
        }

        private void notify(Network newNetwork, boolean available, NetworkCapabilities capabilities, Network previousNetwork) {
            boolean willAvailableChanged = newNetwork.willChanged(available);
            boolean willCapabilitiesChanged = newNetwork.willChanged(capabilities);
            newNetwork.setAvailable(available);
            newNetwork.setCapabilities(capabilities);
            PollerConnectivityManager.this.activeNetwork = newNetwork;
            PollerConnectivityManager.this.setActiveNetwork(newNetwork);
            if (newNetwork != previousNetwork) {
                if (previousNetwork.getCapabilities() == CONNECTED) {
                    previousNetwork.setCapabilities(UNCONNECTED);
                    PollerConnectivityManager.this.notifyNetworkCallbacks(previousNetwork, UNCONNECTED);
                }
                if (previousNetwork.isAvailable()) {
                    previousNetwork.setAvailable(false);
                    PollerConnectivityManager.this.notifyNetworkCallbacks(previousNetwork, false);
                }
            }
            if (available) {
                if (willAvailableChanged) {
                    PollerConnectivityManager.this.notifyNetworkCallbacks(newNetwork, available);
                }
                if (willCapabilitiesChanged) {
                    PollerConnectivityManager.this.notifyNetworkCallbacks(newNetwork, capabilities);
                }
            } else if (newNetwork == previousNetwork) {
                if (willCapabilitiesChanged) {
                    PollerConnectivityManager.this.notifyNetworkCallbacks(newNetwork, capabilities);
                }
                if (willAvailableChanged) {
                    PollerConnectivityManager.this.notifyNetworkCallbacks(newNetwork, available);
                }
            }
        }

        private void updatePollingRate(boolean avaialble, boolean internet) {
            if (internet) {
                if (PollerConnectivityManager.this.currentPeriod != PollerConnectivityManager.this.periodWhenInternet) {
                    PollerConnectivityManager.this.startPolling(PollerConnectivityManager.this.periodWhenInternet, PollerConnectivityManager.this.periodWhenInternet);
                }
            } else if (avaialble && PollerConnectivityManager.this.currentPeriod != PollerConnectivityManager.this.periodWhenAvailable) {
                PollerConnectivityManager.this.startPolling(PollerConnectivityManager.this.periodWhenAvailable, PollerConnectivityManager.this.periodWhenAvailable);
            } else if (!avaialble && PollerConnectivityManager.this.currentPeriod != PollerConnectivityManager.this.periodWhenLost) {
                PollerConnectivityManager.this.startPolling(PollerConnectivityManager.this.periodWhenLost, PollerConnectivityManager.this.periodWhenLost);
            }
        }

        private Network getNetwork(String networkInterface) {
            Network network = (Network)((Object)PollerConnectivityManager.this.networks.get(networkInterface));
            if (network == null) {
                network = new Network(networkInterface);
                PollerConnectivityManager.this.networks.put(networkInterface, network);
            }
            return network;
        }

        private InetAddress checkConnected(NetworkInterface n) {
            InetAddress connectedAddress = null;
            if (n != null) {
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress inetAddress = ee.nextElement();
                    if (!NetUtil.isValidInetAdress((InetAddress)inetAddress)) continue;
                    connectedAddress = inetAddress;
                    break;
                }
            }
            return connectedAddress;
        }
    }
}

